/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.ItemAbstractionPair;
import java.util.BitSet;

public class Pair
implements Comparable<Pair> {
    private final boolean postfix;
    private final ItemAbstractionPair pair;
    private BitSet sequencesID = new BitSet();

    public Pair(boolean postfix, ItemAbstractionPair pair) {
        this.postfix = postfix;
        this.pair = pair;
    }

    public boolean equals(Object object) {
        Pair p = (Pair)object;
        return p.pair.equals(this.pair) && p.postfix == this.postfix;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.postfix ? 1 : 0);
        hash = 59 * hash + (this.pair != null ? this.pair.hashCode() : 0);
        return hash;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public ItemAbstractionPair getPar() {
        return this.pair;
    }

    public int getSupport() {
        return this.sequencesID.cardinality();
    }

    public BitSet getSequencesID() {
        return this.sequencesID;
    }

    public void setSequencesID(BitSet sequencesID) {
        this.sequencesID = sequencesID;
    }

    @Override
    public int compareTo(Pair o) {
        int comparison = this.pair.compareTo(o.pair);
        if (comparison == 0) {
            if (this.postfix == o.postfix) {
                return 0;
            }
            if (this.postfix) {
                return -1;
            }
            return 1;
        }
        return comparison;
    }

    public String toString() {
        String post = "";
        if (this.postfix) {
            post = "*";
        }
        return post + this.pair.toString() + "[" + this.sequencesID.size() + "]";
    }
}

