/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.RecursionCloSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.savers.Saver;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.savers.SaverIntoFile;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.savers.SaverIntoMemory;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class AlgoCloSpan {
    protected double minSupRelative;
    protected double minSupAbsolute;
    protected SequenceDatabase originalDataset;
    Saver saver = null;
    protected long overallStart;
    protected long overallEnd;
    protected long mainMethodStart;
    protected long mainMethodEnd;
    protected long postProcessingStart;
    protected long postProcessingEnd;
    private AbstractionCreator abstractionCreator;
    private int numberOfFrequentPatterns = 0;
    private boolean findClosedPatterns;
    private boolean executePruningMethods;

    public AlgoCloSpan(double minSupRelative, AbstractionCreator creator, boolean findClosedPatterns, boolean executePruningMethods) {
        this.minSupRelative = minSupRelative;
        this.abstractionCreator = creator;
        this.findClosedPatterns = findClosedPatterns;
        this.executePruningMethods = executePruningMethods;
    }

    public void runAlgorithm(SequenceDatabase database, boolean keepPatterns, boolean verbose, String outputFilePath) throws IOException {
        this.minSupAbsolute = (int)Math.ceil(this.minSupRelative * (double)database.size());
        if (this.minSupAbsolute == 0.0) {
            this.minSupAbsolute = 1.0;
        }
        MemoryLogger.getInstance().reset();
        this.overallStart = System.currentTimeMillis();
        this.cloSpan(database, keepPatterns, verbose, this.findClosedPatterns, this.executePruningMethods, outputFilePath);
        this.overallEnd = System.currentTimeMillis();
        this.saver.finish();
    }

    protected void cloSpan(SequenceDatabase database, boolean keepPatterns, boolean verbose, boolean findClosedPatterns, boolean executePruningMethods, String outputFilePath) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory() : new SaverIntoFile(outputFilePath);
        Map<Item, BitSet> mapSequenceID = database.getFrequentItems();
        PseudoSequenceDatabase pseudoDatabase = this.projectInitialDatabase(database, mapSequenceID, (int)this.minSupAbsolute);
        RecursionCloSpan algorithm = new RecursionCloSpan(this.abstractionCreator, this.saver, (int)this.minSupAbsolute, pseudoDatabase, mapSequenceID, findClosedPatterns, executePruningMethods);
        this.mainMethodStart = System.currentTimeMillis();
        algorithm.execute(verbose);
        this.mainMethodEnd = System.currentTimeMillis();
        long timeForMainMethod = (this.mainMethodEnd - this.mainMethodStart) / 1000L;
        this.numberOfFrequentPatterns = algorithm.numberOfFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
        if (verbose) {
            System.out.println("CLOSPAN: The algorithm takes " + timeForMainMethod + " seconds and finds " + this.numberOfFrequentPatterns + " patterns");
        }
        if (findClosedPatterns) {
            List<Pattern> outputPatternsFromMainMethod = algorithm.getFrequentPatterns();
            this.postProcessingStart = System.currentTimeMillis();
            algorithm.removeNonClosedPatterns(outputPatternsFromMainMethod, keepPatterns);
            this.postProcessingEnd = System.currentTimeMillis();
            long timeForPostProcessingStep = (this.postProcessingEnd - this.postProcessingStart) / 1000L;
            this.numberOfFrequentPatterns = algorithm.numberOfFrequentPatterns();
            if (verbose) {
                System.out.println("CLOSPAN: The post-processing algorithm to remove the non-Closed patterns takes " + timeForPostProcessingStep + " seconds and finds " + this.numberOfFrequentPatterns + " Closed patterns");
            }
        } else if (keepPatterns) {
            List<Pattern> outputPatternsFromMainMethod = algorithm.getFrequentPatterns();
            for (Pattern p : outputPatternsFromMainMethod) {
                this.saver.savePattern(p);
            }
        }
        algorithm.clear();
        pseudoDatabase.clear();
        MemoryLogger.getInstance().checkMemory();
    }

    public String printStatistics() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        sb.append(this.getRunningTime());
        sb.append(" ms\n");
        sb.append(" Frequent sequences count : ");
        sb.append(this.numberOfFrequentPatterns);
        sb.append('\n');
        sb.append(" Max memory (mb):");
        sb.append(MemoryLogger.getInstance().getMaxMemory());
        sb.append('\n');
        sb.append(this.saver.print());
        sb.append('\n');
        sb.append("\n===================================================\n");
        return sb.toString();
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public long getRunningTime() {
        return this.overallEnd - this.overallStart;
    }

    public double getAbsoluteMinSupport() {
        return this.minSupAbsolute;
    }

    private PseudoSequenceDatabase projectInitialDatabase(SequenceDatabase database, Map<Item, BitSet> mapSequenceID, long minSupportAbsolute) {
        PseudoSequenceDatabase initialContext = new PseudoSequenceDatabase();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, minSupportAbsolute);
            if (optimizedSequence.size() == 0) continue;
            PseudoSequence pseudoSequence = new PseudoSequence(0L, optimizedSequence, 0, 0);
            initialContext.addSequence(pseudoSequence);
        }
        return initialContext;
    }

    public void clear() {
        if (this.originalDataset != null) {
            this.originalDataset.clear();
            this.originalDataset = null;
        }
        if (this.saver != null) {
            this.saver.clear();
            this.saver = null;
        }
        this.abstractionCreator = null;
    }
}

