/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import java.util.List;

public class PseudoSequence {
    protected Sequence sequence;
    protected int firstItemset;
    protected int firstItem;

    protected PseudoSequence() {
    }

    public Sequence getOriginalSequence() {
        return this.sequence;
    }

    protected PseudoSequence(PseudoSequence sequence, int indexItemset, int indexItem) {
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
    }

    protected PseudoSequence(Sequence sequence, int indexItemset, int indexItem) {
        this.sequence = sequence;
        this.firstItemset = indexItemset;
        this.firstItem = indexItem;
    }

    protected int size() {
        int size = this.sequence.size() - this.firstItemset;
        if (size == 1 && this.sequence.getItemsets().get(this.firstItemset).size() == 0) {
            return 0;
        }
        return size;
    }

    public int getSizeOfItemsetAt(int index) {
        int size = this.sequence.getItemsets().get(index + this.firstItemset).size();
        if (this.isFirstItemset(index)) {
            size -= this.firstItem;
        }
        return size;
    }

    protected boolean isPostfix(int indexItemset) {
        return indexItemset == 0 && this.firstItem != 0;
    }

    protected boolean isFirstItemset(int index) {
        return index == 0;
    }

    protected boolean isLastItemset(int index) {
        return index + this.firstItemset == this.sequence.getItemsets().size() - 1;
    }

    public Integer getItemAtInItemsetAt(int indexItem, int indexItemset) {
        if (this.isFirstItemset(indexItemset)) {
            return this.getItemset(indexItemset).get(indexItem + this.firstItem);
        }
        return this.getItemset(indexItemset).get(indexItem);
    }

    public List<Integer> getItemset(int index) {
        return this.sequence.get(index + this.firstItemset);
    }

    protected int getId() {
        return this.sequence.getId();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.getSizeOfItemsetAt(i); ++j) {
                r.append(this.getItemAtInItemsetAt(j, i).toString());
                if (this.isPostfix(i)) {
                    r.append('*');
                }
                r.append(' ');
            }
            r.append(" -1 ");
        }
        r.append(" -2 ");
        return r.toString();
    }

    protected int indexOfBis(int indexItemset, int idItem) {
        for (int i = 0; i < this.getSizeOfItemsetAt(indexItemset); ++i) {
            if (this.getItemAtInItemsetAt(i, indexItemset) == idItem) {
                return i;
            }
            if (this.getItemAtInItemsetAt(i, indexItemset) <= idItem) continue;
        }
        return -1;
    }

    protected int indexOf(int sizeOfItemsetAti, int indexItemset, int idItem) {
        for (int i = 0; i < sizeOfItemsetAti; ++i) {
            if (this.getItemAtInItemsetAt(i, indexItemset) == idItem) {
                return i;
            }
            if (this.getItemAtInItemsetAt(i, indexItemset) <= idItem) continue;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        PseudoSequence temp = (PseudoSequence)obj;
        return temp.getId() == this.getId() && this.firstItemset == temp.firstItemset && temp.firstItem == this.firstItem;
    }
}

