/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uapriori;

import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.ItemUApriori;
import ca.pfv.spmf.algorithms.frequentpatterns.uapriori.ItemsetUApriori;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UncertainTransactionDatabase {
    private final Set<ItemUApriori> allItems = new HashSet<ItemUApriori>();
    private final List<ItemsetUApriori> transactions = new ArrayList<ItemsetUApriori>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.processTransactions(thisLine.split(" "));
            }
        }
    }

    private void processTransactions(String[] itemsString) {
        ItemsetUApriori transaction = new ItemsetUApriori();
        for (String itemString : itemsString) {
            int indexOfLeftParanthesis = itemString.indexOf(40);
            int indexOfRightParanthesis = itemString.indexOf(41);
            int itemID = Integer.parseInt(itemString.substring(0, indexOfLeftParanthesis));
            double value = Double.parseDouble(itemString.substring(indexOfLeftParanthesis + 1, indexOfRightParanthesis));
            ItemUApriori item = new ItemUApriori(itemID, value);
            transaction.addItem(item);
            this.allItems.add(item);
        }
        this.transactions.add(transaction);
    }

    public void printDatabase() {
        System.out.println("===================  UNCERTAIN DATABASE ===================");
        int count = 0;
        for (ItemsetUApriori itemset : this.transactions) {
            System.out.print("0" + count + ":  ");
            itemset.print();
            System.out.println("");
            ++count;
        }
    }

    public int size() {
        return this.transactions.size();
    }

    public List<ItemsetUApriori> getTransactions() {
        return this.transactions;
    }

    public Set<ItemUApriori> getAllItems() {
        return this.allItems;
    }
}

