/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lcm.bak;

import ca.pfv.spmf.algorithms.frequentpatterns.lcm.bak.Dataset;
import ca.pfv.spmf.algorithms.frequentpatterns.lcm.bak.Transaction;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AlgoLCM {
    private Itemsets closedFrequentItemsets;
    BufferedWriter writer = null;
    private int frequentCount;
    long startTimestamp;
    long endTimestamp;
    int minsupRelative;
    boolean mineAllFrequentItemsets;
    private boolean mineAllMaximalItemsets;
    Integer[] allItems;
    private List<Transaction>[] buckets;

    public Itemsets runAlgorithm(double minimumSupport, Dataset dataset, String outputPath, boolean mineAllFrequentItemsets, boolean mineAllMaximalItemsets) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.mineAllFrequentItemsets = mineAllFrequentItemsets;
        this.mineAllMaximalItemsets = mineAllMaximalItemsets;
        if (outputPath != null) {
            this.writer = new BufferedWriter(new FileWriter(outputPath));
        } else {
            this.writer = null;
            this.closedFrequentItemsets = new Itemsets("Itemsets");
        }
        this.frequentCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsupRelative = (int)Math.ceil(minimumSupport * (double)dataset.getTransactions().size());
        this.performFirstOccurenceDelivery(dataset);
        for (Transaction transaction : dataset.getTransactions()) {
            transaction.removeInfrequentItems(this.buckets, this.minsupRelative);
        }
        Integer[] temp = new Integer[dataset.getUniqueItems().size()];
        int i = 0;
        for (Integer item : dataset.getUniqueItems()) {
            if (this.buckets[item].size() >= this.minsupRelative) {
                temp[i++] = item;
                continue;
            }
            this.buckets[item.intValue()] = null;
        }
        this.allItems = new Integer[i];
        System.arraycopy(temp, 0, this.allItems, 0, i);
        Arrays.sort((Object[])this.allItems);
        if (mineAllFrequentItemsets) {
            this.backtrackingLCMFreq(null, dataset.getTransactions(), 0, 0, -1, 0);
        } else if (mineAllMaximalItemsets) {
            this.backtrackingLCMMax(null, dataset.getTransactions(), 0, 0, -1);
        } else {
            this.backtrackingLCM(null, dataset.getTransactions(), 0, 0, -1);
        }
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        return this.closedFrequentItemsets;
    }

    private void backtrackingLCM(List<Integer> p, List<Transaction> transactionsOfP, int tailItemOfP, int tailIndexP1, int tailPositionInP) throws IOException {
        ArrayList<Integer> frequentItemsIndexes = new ArrayList<Integer>();
        for (int i = tailIndexP1; i < this.allItems.length; ++i) {
            Integer e = this.allItems[i];
            int support = this.buckets[e].size();
            if (support < this.minsupRelative || p != null && this.containsByBinarySearch(p, e, tailPositionInP)) continue;
            frequentItemsIndexes.add(i);
        }
        for (Integer eIndex : frequentItemsIndexes) {
            List<Transaction> transactionsPe;
            Integer e = this.allItems[eIndex];
            if (!this.isPPCExtension(p, e, transactionsPe = this.intersectTransactions(transactionsOfP, e))) continue;
            ArrayList<Integer> itemset = new ArrayList<Integer>();
            if (p != null) {
                for (int i = 0; i < p.size() && p.get(i) < e; ++i) {
                    itemset.add(p.get(i));
                }
            }
            int ePositionInP = itemset.size();
            itemset.add(e);
            for (int i = eIndex + 1; i < this.allItems.length; ++i) {
                Integer itemI = this.allItems[i];
                if (this.containsByBinarySearch(itemset, itemI, ePositionInP) || !this.isItemInAllTransactions(transactionsPe, itemI)) continue;
                itemset.add(itemI);
            }
            this.output(itemset, transactionsPe.size());
            this.anyTimeDatabaseReduction(transactionsPe, e, eIndex);
            this.backtrackingLCM(itemset, transactionsPe, e, eIndex + 1, ePositionInP);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void backtrackingLCMMax(List<Integer> p, List<Transaction> transactionsOfP, int tailItemOfP, int tailIndexP1, int tailPositionInP) throws IOException {
        ArrayList<Integer> frequentItemsIndexes = new ArrayList<Integer>();
        for (int i = tailIndexP1; i < this.allItems.length; ++i) {
            Integer e = this.allItems[i];
            int support = this.buckets[e].size();
            if (support < this.minsupRelative || p != null && this.containsByBinarySearch(p, e, tailPositionInP)) continue;
            frequentItemsIndexes.add(i);
        }
        for (Integer eIndex : frequentItemsIndexes) {
            Integer e = this.allItems[eIndex];
            List<Transaction> transactionsPe = this.intersectTransactions(transactionsOfP, e);
            if (!this.isPPCMaxExtension(p, e, transactionsOfP)) continue;
            ArrayList<Integer> itemset = new ArrayList<Integer>();
            if (p != null) {
                for (int i = 0; i < p.size() && p.get(i) < e; ++i) {
                    itemset.add(p.get(i));
                }
            }
            int ePositionInP = itemset.size();
            itemset.add(e);
            for (int i = eIndex + 1; i < this.allItems.length; ++i) {
                Integer itemI = this.allItems[i];
                if (this.containsByBinarySearch(itemset, itemI, ePositionInP) || !this.isItemInAtLeastMinsupTransactions(transactionsPe, itemI)) continue;
                itemset.add(itemI);
            }
            this.output(itemset, transactionsPe.size());
            this.anyTimeDatabaseReduction(transactionsPe, e, eIndex);
            this.backtrackingLCMMax(itemset, transactionsPe, e, eIndex + 1, ePositionInP);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void backtrackingLCMFreq(List<Integer> p, List<Transaction> transactionsOfP, int tailItemOfP, int tailIndexP1, int tailPositionInP, int sizeOfP) throws IOException {
        ArrayList<Integer> frequentItemsIndexes = new ArrayList<Integer>();
        for (int i = tailIndexP1; i < this.allItems.length; ++i) {
            Integer e = this.allItems[i];
            int support = this.buckets[e].size();
            if (support < this.minsupRelative || p != null && this.containsByBinarySearch(p, e, tailPositionInP)) continue;
            frequentItemsIndexes.add(i);
        }
        for (Integer eIndex : frequentItemsIndexes) {
            Integer e = this.allItems[eIndex];
            List<Transaction> transactionsPe = this.intersectTransactions(transactionsOfP, e);
            ArrayList<Integer> itemset = new ArrayList<Integer>(sizeOfP + 1);
            if (sizeOfP > 0) {
                itemset.addAll(p);
            }
            itemset.add(e);
            int ePositionInP = sizeOfP;
            this.output(itemset, transactionsPe.size());
            this.anyTimeDatabaseReduction(transactionsPe, e, eIndex);
            this.backtrackingLCMFreq(itemset, transactionsPe, e, eIndex + 1, ePositionInP, sizeOfP + 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void performFirstOccurenceDelivery(Dataset dataset) {
        this.buckets = new List[dataset.getMaxItem() + 1];
        for (Integer item : dataset.uniqueItems) {
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : dataset.getTransactions()) {
            for (Integer item : transaction.getItems()) {
                this.buckets[item].add(transaction);
            }
        }
    }

    private void anyTimeDatabaseReduction(List<Transaction> transactions, int e, Integer eIndex) {
        for (int i = eIndex + 1; i < this.buckets.length; ++i) {
            this.buckets[i] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : transactions) {
            for (int i = transaction.getItems().length - 1; i > transaction.offset; --i) {
                Integer item = transaction.getItems()[i];
                this.buckets[item].add(transaction);
            }
        }
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item, int searchAfterPosition) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = searchAfterPosition + 1;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = 0;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public List<Transaction> intersectTransactions(List<Transaction> transactionsOfP, Integer e) {
        ArrayList<Transaction> transactionsPe = new ArrayList<Transaction>();
        for (Transaction transaction : transactionsOfP) {
            int posE = transaction.containsByBinarySearch(e);
            if (posE == -1) continue;
            transactionsPe.add(new Transaction(transaction, posE));
        }
        return transactionsPe;
    }

    private boolean isPPCExtension(List<Integer> p, Integer e, List<Transaction> transactionsPe) {
        Transaction firstTrans = transactionsPe.get(0);
        Integer[] firstTransaction = firstTrans.getItems();
        for (int i = 0; i < firstTrans.offset; ++i) {
            Integer item = firstTransaction[i];
            if (p != null && this.containsByBinarySearch(p, item) || !this.isItemInAllTransactionsExceptFirst(transactionsPe, item)) continue;
            return false;
        }
        return true;
    }

    private boolean isPPCMaxExtension(List<Integer> p, Integer e, List<Transaction> transactionsPe) {
        Integer item;
        Transaction firstTrans = transactionsPe.get(0);
        Integer[] firstTransaction = firstTrans.getItems();
        for (int i = 0; i < firstTransaction.length && (item = firstTransaction[i]) < e; ++i) {
            if (p != null && this.containsByBinarySearch(p, item) || !this.isItemInAtLeastMinsupTransactionsWithoutFirst(transactionsPe, item)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemInAtLeastMinsupTransactionsWithoutFirst(List<Transaction> transactions, Integer item) {
        int supCount = 1;
        for (int i = 1; i < transactions.size(); ++i) {
            if (!transactions.get(i).containsByBinarySearchOriginalTransaction(item) || ++supCount != this.minsupRelative) continue;
            return true;
        }
        return false;
    }

    private boolean isItemInAtLeastMinsupTransactions(List<Transaction> transactions, Integer item) {
        int supCount = 0;
        for (Transaction transaction : transactions) {
            if (transaction.containsByBinarySearch(item) == -1 || ++supCount != this.minsupRelative) continue;
            return true;
        }
        return false;
    }

    private boolean isItemInAllTransactionsExceptFirst(List<Transaction> transactions, Integer item) {
        for (int i = 1; i < transactions.size(); ++i) {
            if (transactions.get(i).containsByBinarySearchOriginalTransaction(item)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemInAllTransactions(List<Transaction> transactions, Integer item) {
        for (Transaction transaction : transactions) {
            if (transaction.containsByBinarySearch(item) != -1) continue;
            return false;
        }
        return true;
    }

    private void output(List<Integer> itemset, int support) throws IOException {
        if (!itemset.isEmpty()) {
            ++this.frequentCount;
            if (this.writer == null) {
                this.closedFrequentItemsets.addItemset(new Itemset(itemset, support), itemset.size());
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < itemset.size(); ++i) {
                    buffer.append(itemset.get(i));
                    if (i == itemset.size() - 1) continue;
                    buffer.append(' ');
                }
                buffer.append(" #SUP: ");
                buffer.append(support);
                this.writer.write(buffer.toString());
                this.writer.newLine();
            }
        }
    }

    public void printStats() {
        if (this.mineAllFrequentItemsets) {
            System.out.println("========== LCMFreq - STATS ============");
            System.out.println(" Freq. itemsets count: " + this.frequentCount);
        } else if (this.mineAllMaximalItemsets) {
            System.out.println("========== LCMMax - STATS ============");
            System.out.println(" Freq. maximal itemsets count: " + this.frequentCount);
        } else {
            System.out.println("========== LCM - STATS ============");
            System.out.println(" Freq. closed itemsets count: " + this.frequentCount);
        }
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }
}

