/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings.FPNode_Strings;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth_with_strings.FPTree_Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFPGrowth_Strings {
    private long startTimestamp;
    private long endTime;
    private int transactionCount = 0;
    private int itemsetCount;
    public int relativeMinsupp;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, double minsupp) throws FileNotFoundException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.writer = new BufferedWriter(new FileWriter(output));
        final HashMap<String, Integer> mapSupport = new HashMap<String, Integer>();
        this.scanDatabaseToDetermineFrequencyOfSingleItems(input, mapSupport);
        this.relativeMinsupp = (int)Math.ceil(minsupp * (double)this.transactionCount);
        FPTree_Strings tree = new FPTree_Strings();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<String> transaction = new ArrayList<String>();
            for (String itemString : lineSplited) {
                if ((Integer)mapSupport.get(itemString) < this.relativeMinsupp) continue;
                transaction.add(itemString);
            }
            Collections.sort(transaction, new Comparator<String>(){

                @Override
                public int compare(String item1, String item2) {
                    int compare = (Integer)mapSupport.get(item2) - (Integer)mapSupport.get(item1);
                    if (compare == 0) {
                        return item1.compareTo(item2);
                    }
                    return compare;
                }
            });
            tree.addTransaction(transaction);
        }
        reader.close();
        tree.createHeaderList(mapSupport);
        String[] prefixAlpha = new String[]{};
        if (tree.headerList.size() > 0) {
            this.fpgrowth(tree, prefixAlpha, this.transactionCount, mapSupport);
        }
        this.writer.close();
        this.endTime = System.currentTimeMillis();
    }

    private void scanDatabaseToDetermineFrequencyOfSingleItems(String input, Map<String, Integer> mapSupport) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer count = mapSupport.get(itemString);
                if (count == null) {
                    mapSupport.put(itemString, 1);
                    continue;
                }
                count = count + 1;
                mapSupport.put(itemString, count);
            }
            ++this.transactionCount;
        }
        reader.close();
    }

    private void fpgrowth(FPTree_Strings tree, String[] prefixAlpha, int prefixSupport, Map<String, Integer> mapSupport) throws IOException {
        if (!tree.hasMoreThanOnePath) {
            this.addAllCombinationsForPathAndPrefix(tree.root.childs.get(0), prefixAlpha);
        } else {
            this.fpgrowthMoreThanOnePath(tree, prefixAlpha, prefixSupport, mapSupport);
        }
    }

    private void fpgrowthMoreThanOnePath(FPTree_Strings tree, String[] prefixAlpha, int prefixSupport, Map<String, Integer> mapSupport) throws IOException {
        for (int i = tree.headerList.size() - 1; i >= 0; --i) {
            String item = tree.headerList.get(i);
            int support = mapSupport.get(item);
            if (support < this.relativeMinsupp) continue;
            String[] beta = new String[prefixAlpha.length + 1];
            System.arraycopy(prefixAlpha, 0, beta, 0, prefixAlpha.length);
            beta[prefixAlpha.length] = item;
            int betaSupport = prefixSupport < support ? prefixSupport : support;
            this.writeItemsetToFile(beta, betaSupport);
            ArrayList prefixPaths = new ArrayList();
            FPNode_Strings path = tree.mapItemNodes.get(item);
            while (path != null) {
                if (path.parent.itemID != null) {
                    ArrayList<FPNode_Strings> prefixPath = new ArrayList<FPNode_Strings>();
                    prefixPath.add(path);
                    FPNode_Strings parent = path.parent;
                    while (parent.itemID != null) {
                        prefixPath.add(parent);
                        parent = parent.parent;
                    }
                    prefixPaths.add(prefixPath);
                }
                path = path.nodeLink;
            }
            HashMap<String, Integer> mapSupportBeta = new HashMap<String, Integer>();
            for (List list : prefixPaths) {
                int n = ((FPNode_Strings)list.get((int)0)).counter;
                for (int j = 1; j < list.size(); ++j) {
                    FPNode_Strings node = (FPNode_Strings)list.get(j);
                    if (mapSupportBeta.get(node.itemID) == null) {
                        mapSupportBeta.put(node.itemID, n);
                        continue;
                    }
                    mapSupportBeta.put(node.itemID, (Integer)mapSupportBeta.get(node.itemID) + n);
                }
            }
            FPTree_Strings treeBeta = new FPTree_Strings();
            for (List list : prefixPaths) {
                treeBeta.addPrefixPath(list, mapSupportBeta, this.relativeMinsupp);
            }
            treeBeta.createHeaderList(mapSupportBeta);
            if (treeBeta.root.childs.size() <= 0) continue;
            this.fpgrowth(treeBeta, beta, betaSupport, mapSupportBeta);
        }
    }

    private void addAllCombinationsForPathAndPrefix(FPNode_Strings node, String[] prefix) throws IOException {
        String[] itemset = new String[prefix.length + 1];
        System.arraycopy(prefix, 0, itemset, 0, prefix.length);
        itemset[prefix.length] = node.itemID;
        this.writeItemsetToFile(itemset, node.counter);
        if (node.childs.size() != 0) {
            this.addAllCombinationsForPathAndPrefix(node.childs.get(0), itemset);
            this.addAllCombinationsForPathAndPrefix(node.childs.get(0), prefix);
        }
    }

    private void writeItemsetToFile(String[] itemset, int support) throws IOException {
        ++this.itemsetCount;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < itemset.length; ++i) {
            buffer.append(itemset[i]);
            if (i == itemset.length - 1) continue;
            buffer.append(' ');
        }
        buffer.append(':');
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  FP-GROWTH - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.transactionCount);
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }
}

