/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.charm;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.charm.HashTable;
import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoCharm_Bitset {
    private int minsupRelative;
    protected TransactionDatabase database;
    protected long startTimestamp;
    protected long endTime;
    protected Itemsets closedItemsets;
    BufferedWriter writer = null;
    protected int itemsetCount;
    private TriangularMatrix matrix;
    private HashTable hash;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, double minsup, boolean useTriangularMatrixOptimization, int hashTableSize) throws IOException {
        MemoryLogger.getInstance().reset();
        if (output == null) {
            this.writer = null;
            this.closedItemsets = new Itemsets("FREQUENT CLOSED ITEMSETS");
        } else {
            this.closedItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.hash = new HashTable(hashTableSize);
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsup * (double)database.size());
        final HashMap<Integer, BitSetSupport> mapItemTIDS = new HashMap<Integer, BitSetSupport>();
        int maxItemId = 0;
        maxItemId = this.calculateSupportSingleItems(database, mapItemTIDS, maxItemId);
        if (useTriangularMatrixOptimization) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset : database.getTransactions()) {
                Object[] array = itemset.toArray();
                for (int i = 0; i < itemset.size(); ++i) {
                    Integer itemI = (Integer)array[i];
                    for (int j = i + 1; j < itemset.size(); ++j) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                    }
                }
            }
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemTIDS.entrySet()) {
            BitSetSupport tidset = (BitSetSupport)entry.getValue();
            int support = tidset.support;
            int item = (Integer)entry.getKey();
            if (support < this.minsupRelative) continue;
            frequentItems.add(item);
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((BitSetSupport)mapItemTIDS.get((Object)arg0)).support - ((BitSetSupport)mapItemTIDS.get((Object)arg1)).support;
            }
        });
        for (int i = 0; i < frequentItems.size(); ++i) {
            Integer itemX = (Integer)frequentItems.get(i);
            if (itemX == null) continue;
            BitSetSupport tidsetX = (BitSetSupport)mapItemTIDS.get(itemX);
            int[] itemsetX = new int[]{itemX};
            ArrayList<int[]> equivalenceClassIitemsets = new ArrayList<int[]>();
            ArrayList<BitSetSupport> equivalenceClassItidsets = new ArrayList<BitSetSupport>();
            for (int j = i + 1; j < frequentItems.size(); ++j) {
                int[] realUnion;
                Integer itemJ = (Integer)frequentItems.get(j);
                if (itemJ == null) continue;
                int supportIJ = -1;
                if (itemsetX.length == 1 && useTriangularMatrixOptimization && (supportIJ = this.matrix.getSupportForItems(itemX, itemJ)) < this.minsupRelative) continue;
                BitSetSupport tidsetJ = (BitSetSupport)mapItemTIDS.get(itemJ);
                BitSetSupport bitsetSupportUnion = new BitSetSupport();
                bitsetSupportUnion = itemsetX.length == 1 && useTriangularMatrixOptimization ? this.performANDFirstTime(tidsetX, tidsetJ, supportIJ) : this.performAND(tidsetX, tidsetJ);
                if (bitsetSupportUnion.support < this.minsupRelative) continue;
                if (tidsetX.support == tidsetJ.support && bitsetSupportUnion.support == tidsetX.support) {
                    frequentItems.set(j, null);
                    realUnion = new int[itemsetX.length + 1];
                    System.arraycopy(itemsetX, 0, realUnion, 0, itemsetX.length);
                    realUnion[itemsetX.length] = itemJ;
                    itemsetX = realUnion;
                    continue;
                }
                if (tidsetX.support < tidsetJ.support && bitsetSupportUnion.support == tidsetX.support) {
                    realUnion = new int[itemsetX.length + 1];
                    System.arraycopy(itemsetX, 0, realUnion, 0, itemsetX.length);
                    realUnion[itemsetX.length] = itemJ;
                    itemsetX = realUnion;
                    continue;
                }
                if (tidsetX.support > tidsetJ.support && bitsetSupportUnion.support == tidsetJ.support) {
                    frequentItems.set(j, null);
                    equivalenceClassIitemsets.add(new int[]{itemJ});
                    equivalenceClassItidsets.add(bitsetSupportUnion);
                    continue;
                }
                equivalenceClassIitemsets.add(new int[]{itemJ});
                equivalenceClassItidsets.add(bitsetSupportUnion);
            }
            if (equivalenceClassIitemsets.size() > 0) {
                this.processEquivalenceClass(itemsetX, equivalenceClassIitemsets, equivalenceClassItidsets);
            }
            this.save(null, itemsetX, tidsetX);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        return this.closedItemsets;
    }

    private int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, BitSetSupport> mapItemTIDS, int maxItemId) {
        for (int i = 0; i < database.size(); ++i) {
            for (Integer item : database.getTransactions().get(i)) {
                BitSetSupport tids = mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new BitSetSupport();
                    mapItemTIDS.put(item, tids);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                tids.bitset.set(i);
                ++tids.support;
            }
        }
        return maxItemId;
    }

    private BitSetSupport performANDFirstTime(BitSetSupport tidsetI, BitSetSupport tidsetJ, int supportIJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = supportIJ;
        return bitsetSupportIJ;
    }

    private BitSetSupport performAND(BitSetSupport tidsetI, BitSetSupport tidsetJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    private void processEquivalenceClass(int[] prefix, List<int[]> equivalenceClassItemsets, List<BitSetSupport> equivalenceClassTidsets) throws IOException {
        if (equivalenceClassItemsets.size() == 1) {
            int[] itemsetI = equivalenceClassItemsets.get(0);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(0);
            this.save(prefix, itemsetI, tidsetI);
            return;
        }
        if (equivalenceClassItemsets.size() == 2) {
            int[] itemsetI = equivalenceClassItemsets.get(0);
            BitSetSupport tidsetI = equivalenceClassTidsets.get(0);
            int[] itemsetJ = equivalenceClassItemsets.get(1);
            BitSetSupport tidsetJ = equivalenceClassTidsets.get(1);
            BitSetSupport bitsetSupportIJ = this.performAND(tidsetI, tidsetJ);
            if (bitsetSupportIJ.support >= this.minsupRelative) {
                int[] suffixIJ = ArraysAlgos.concatenate(itemsetI, itemsetJ);
                this.save(prefix, suffixIJ, bitsetSupportIJ);
            }
            if (bitsetSupportIJ.support != tidsetI.support) {
                this.save(prefix, itemsetI, tidsetI);
            }
            if (bitsetSupportIJ.support != tidsetJ.support) {
                this.save(prefix, itemsetJ, tidsetJ);
            }
            return;
        }
        for (int i = 0; i < equivalenceClassItemsets.size(); ++i) {
            int[] itemsetX = equivalenceClassItemsets.get(i);
            if (itemsetX == null) continue;
            BitSetSupport tidsetX = equivalenceClassTidsets.get(i);
            ArrayList<int[]> equivalenceClassIitemsets = new ArrayList<int[]>();
            ArrayList<BitSetSupport> equivalenceClassItidsets = new ArrayList<BitSetSupport>();
            for (int j = i + 1; j < equivalenceClassItemsets.size(); ++j) {
                int[] realUnion;
                int[] itemsetJ = equivalenceClassItemsets.get(j);
                if (itemsetJ == null) continue;
                BitSetSupport tidsetJ = equivalenceClassTidsets.get(j);
                BitSetSupport bitsetSupportUnion = new BitSetSupport();
                bitsetSupportUnion = this.performAND(tidsetX, tidsetJ);
                if (bitsetSupportUnion.support < this.minsupRelative) continue;
                if (tidsetX.support == tidsetJ.support && bitsetSupportUnion.support == tidsetX.support) {
                    equivalenceClassItemsets.set(j, null);
                    equivalenceClassTidsets.set(j, null);
                    realUnion = ArraysAlgos.concatenate(itemsetX, itemsetJ);
                    itemsetX = realUnion;
                    continue;
                }
                if (tidsetX.support < tidsetJ.support && bitsetSupportUnion.support == tidsetX.support) {
                    realUnion = ArraysAlgos.concatenate(itemsetX, itemsetJ);
                    itemsetX = realUnion;
                    continue;
                }
                if (tidsetX.support > tidsetJ.support && bitsetSupportUnion.support == tidsetJ.support) {
                    equivalenceClassItemsets.set(j, null);
                    equivalenceClassTidsets.set(j, null);
                    equivalenceClassIitemsets.add(itemsetJ);
                    equivalenceClassItidsets.add(bitsetSupportUnion);
                    continue;
                }
                equivalenceClassIitemsets.add(itemsetJ);
                equivalenceClassItidsets.add(bitsetSupportUnion);
            }
            if (equivalenceClassIitemsets.size() > 0) {
                int[] newPrefix = ArraysAlgos.concatenate(prefix, itemsetX);
                this.processEquivalenceClass(newPrefix, equivalenceClassIitemsets, equivalenceClassItidsets);
            }
            this.save(prefix, itemsetX, tidsetX);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void printStats() {
        System.out.println("=============  CHARM v96e Bitset - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent closed itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    public Itemsets getClosedItemsets() {
        return this.closedItemsets;
    }

    private void save(int[] prefix, int[] suffix, BitSetSupport tidset) throws IOException {
        int[] prefixSuffix = prefix == null ? suffix : ArraysAlgos.concatenate(prefix, suffix);
        Arrays.sort(prefixSuffix);
        Itemset itemset = new Itemset(prefixSuffix);
        itemset.setAbsoluteSupport(tidset.support);
        int hashcode = this.hash.hashCode(tidset.bitset);
        if (!this.hash.containsSupersetOf(itemset, hashcode)) {
            ++this.itemsetCount;
            if (this.writer == null) {
                ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset itemsetWithTidset = new ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset(prefixSuffix, tidset.bitset, tidset.support);
                this.closedItemsets.addItemset(itemsetWithTidset, itemset.size());
            } else {
                this.writer.write(itemset.toString() + " #SUP: " + itemset.support);
                this.writer.newLine();
            }
            this.hash.put(itemset, hashcode);
        }
    }

    public class BitSetSupport {
        BitSet bitset = new BitSet();
        int support;
    }
}

