/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.apriori_HT;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import java.util.ArrayList;
import java.util.List;

public class ItemsetHashTree {
    private int branch_count = 30;
    private int itemsetSize;
    int candidateCount;
    InnerNode root;
    LeafNode lastInsertedNode = null;

    public ItemsetHashTree(int itemsetSize, int branch_count) {
        this.itemsetSize = itemsetSize;
        this.branch_count = branch_count;
        this.root = new InnerNode();
    }

    public void insertCandidateItemset(Itemset itemset) {
        ++this.candidateCount;
        this.insertCandidateItemset(this.root, itemset, 0);
    }

    private void insertCandidateItemset(Node node, Itemset itemset, int level) {
        int branchIndex = itemset.itemset[level] % this.branch_count;
        if (node instanceof LeafNode) {
            List<Itemset> list = ((LeafNode)node).candidates[branchIndex];
            if (list == null) {
                ((LeafNode)node).candidates[branchIndex] = list = new ArrayList<Itemset>();
            }
            list.add(itemset);
        } else {
            Node nextNode = ((InnerNode)node).childs[branchIndex];
            if (nextNode == null) {
                if (level == this.itemsetSize - 2) {
                    nextNode = new LeafNode();
                    ((LeafNode)nextNode).nextLeafNode = this.lastInsertedNode;
                    this.lastInsertedNode = (LeafNode)nextNode;
                } else {
                    nextNode = new InnerNode();
                }
                ((InnerNode)node).childs[branchIndex] = nextNode;
            }
            this.insertCandidateItemset(nextNode, itemset, level + 1);
        }
    }

    public void updateSupportCount(int[] transaction) {
        this.updateSupportCount(transaction, this.root, 0, new int[0]);
    }

    private void updateSupportCount(int[] transaction, InnerNode node, int firstPositionToCheck, int[] prefix) {
        int lastPosition = transaction.length - 1;
        int lastPositionToCheck = transaction.length - this.itemsetSize + prefix.length;
        for (int i = firstPositionToCheck; i <= lastPositionToCheck; ++i) {
            int itemI = transaction[i];
            int branchIndex = itemI % this.branch_count;
            Node nextNode = node.childs[branchIndex];
            if (nextNode == null) continue;
            if (nextNode instanceof InnerNode) {
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = itemI;
                this.updateSupportCount(transaction, (InnerNode)nextNode, i + 1, newPrefix);
                continue;
            }
            LeafNode theNode = (LeafNode)nextNode;
            for (int j = i + 1; j <= lastPosition; ++j) {
                int itemJ = transaction[j];
                int branchIndexNextNode = itemJ % this.branch_count;
                List<Itemset> listCandidates = theNode.candidates[branchIndexNextNode];
                if (listCandidates == null) continue;
                for (Itemset candidate : listCandidates) {
                    if (!this.sameAsPrefix(candidate.itemset, prefix, itemI, itemJ)) continue;
                    ++candidate.support;
                }
            }
        }
    }

    public boolean isInTheTree(int[] itemset, int posRemoved) {
        Node node = this.root;
        int count = 0;
        block0: for (int i = 0; i < itemset.length; ++i) {
            if (i == posRemoved) continue;
            int branchIndex = itemset[i] % this.branch_count;
            if (++count == this.itemsetSize) {
                if (node == null) {
                    return false;
                }
                List<Itemset> list = ((LeafNode)node).candidates[branchIndex];
                if (list == null) {
                    return false;
                }
                int first = 0;
                int last = list.size() - 1;
                while (first <= last) {
                    int middle = (first + last) / 2;
                    if (ArraysAlgos.sameAs(list.get(middle).getItems(), itemset, posRemoved) < 0) {
                        first = middle + 1;
                        continue;
                    }
                    if (ArraysAlgos.sameAs(list.get(middle).getItems(), itemset, posRemoved) <= 0) break block0;
                    last = middle - 1;
                }
                return false;
            }
            if (node == null) {
                return false;
            }
            node = node.childs[branchIndex];
        }
        return true;
    }

    private boolean sameAsPrefix(int[] itemset1, int[] prefix, int itemI, int itemJ) {
        for (int i = 0; i < prefix.length; ++i) {
            if (itemset1[i] == prefix[i]) continue;
            return false;
        }
        return itemset1[itemset1.length - 2] == itemI && itemset1[itemset1.length - 1] == itemJ;
    }

    class LeafNode
    extends Node {
        final List<Itemset>[] candidates;
        LeafNode nextLeafNode;

        LeafNode() {
            this.candidates = new ArrayList[ItemsetHashTree.this.branch_count];
            this.nextLeafNode = null;
        }
    }

    class InnerNode
    extends Node {
        Node[] childs;

        InnerNode() {
            this.childs = new Node[ItemsetHashTree.this.branch_count];
        }
    }

    abstract class Node {
        Node() {
        }
    }
}

