/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool.wrappers.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IO;

public class OdbFileIO
implements IO {
    private String fileName;
    private RandomAccessFile fileAccess;
    private FileLock fileLock;

    public OdbFileIO() throws IOException {
    }

    public OdbFileIO(String fileName, boolean canWrite, String password) throws IOException {
        this.init(fileName, canWrite, password);
    }

    @Override
    public void init(String fileName, boolean canWrite, String password) throws IOException {
        this.fileName = fileName;
        try {
            this.fileAccess = new RandomAccessFile(fileName, canWrite ? "rw" : "r");
        }
        catch (IOException e) {
            throw new ODBRuntimeException(e, "Error while opening file " + fileName);
        }
    }

    @Override
    public long length() throws IOException {
        return this.fileAccess.length();
    }

    @Override
    public void seek(long position) throws IOException {
        try {
            if (position < 0L) {
                throw new ODBRuntimeException(NeoDatisError.NEGATIVE_POSITION.addParameter(position));
            }
            this.fileAccess.seek(position);
        }
        catch (IOException e) {
            throw new ODBRuntimeException(NeoDatisError.GO_TO_POSITION.addParameter(position).addParameter(this.fileAccess.length()), (Throwable)e);
        }
    }

    @Override
    public void write(byte b) throws IOException {
        this.fileAccess.writeByte(b);
    }

    @Override
    public void write(byte[] bs, int offset, int size) throws IOException {
        this.fileAccess.write(bs, offset, size);
    }

    @Override
    public int read() throws IOException {
        return this.fileAccess.read();
    }

    @Override
    public long read(byte[] array, int offset, int size) throws IOException {
        return this.fileAccess.read(array, offset, size);
    }

    @Override
    public void close() throws IOException {
        this.flushIO();
        this.fileAccess.close();
    }

    @Override
    public boolean lockFile() throws IOException {
        this.fileLock = this.fileAccess.getChannel().tryLock(0L, 1L, false);
        return this.fileLock != null;
    }

    @Override
    public boolean unlockFile() throws IOException {
        this.fileLock.release();
        this.fileLock = null;
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.fileLock != null;
    }

    @Override
    public void flushIO() throws IOException {
        this.fileAccess.getChannel().force(true);
    }
}

