/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.layers.layer3.engine;

import java.io.IOException;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.server.layers.layer3.engine.IMessageStreamer;
import org.neodatis.odb.core.server.layers.layer3.engine.Message;

public class ServerAdmin {
    private IMessageStreamer messageStreamer;
    private String host;
    private int port;

    public ServerAdmin(String host, int port) {
        this.host = host;
        this.port = port;
        this.messageStreamer = OdbConfiguration.getCoreProvider().getMessageStreamer(host, port, "ServerAdmin");
    }

    public void close() throws IOException {
        this.messageStreamer.close();
    }

    public Message sendMessage(Message msg) {
        Message rmsg;
        try {
            this.messageStreamer.write(msg);
            rmsg = this.messageStreamer.read();
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.CLIENT_NET_ERROR, (Throwable)e);
        }
        return rmsg;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

