/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.buffer;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.IBufferedIO;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.io.MultiBufferVO;

public abstract class MultiBufferedIO
implements IBufferedIO {
    public static long nbWrites;
    public static long totalWriteSize;
    public static long numberOfFlush;
    public static long totalFlushSize;
    public static int nbFlushForOverlap;
    public static int nbBufferOk;
    public static int nbBufferNotOk;
    public static int nbSamePositionForWrite;
    public static int nbSamePositionForRead;
    public static final String LOG_ID = "MultiBufferedIO";
    private static final int READ = 1;
    private static final int WRITE = 2;
    private String name;
    private long ioDeviceLength;
    private MultiBufferVO multiBuffer;
    private int nbBuffers;
    private int[] overlappingBuffers;
    private int currentBufferIndex;
    private int bufferSize;
    private boolean isUsingBuffer;
    protected long currentPositionWhenUsingBuffer;
    private long currentPositionForDirectWrite;
    private boolean enableAutomaticDelete;
    private int nextBufferIndex;

    public MultiBufferedIO(int nbBuffers, String name, int bufferSize, boolean canWrite) {
        this.nbBuffers = nbBuffers;
        this.multiBuffer = new MultiBufferVO(nbBuffers, bufferSize);
        this.bufferSize = bufferSize;
        this.currentPositionWhenUsingBuffer = -1L;
        this.currentPositionForDirectWrite = -1L;
        this.overlappingBuffers = new int[nbBuffers];
        numberOfFlush = 0L;
        this.isUsingBuffer = true;
        this.name = name;
        this.enableAutomaticDelete = true;
        this.nextBufferIndex = 0;
    }

    @Override
    public abstract void goToPosition(long var1);

    @Override
    public abstract long getLength();

    public abstract void internalWrite(byte var1);

    public abstract void internalWrite(byte[] var1, int var2);

    public abstract byte internalRead();

    public abstract long internalRead(byte[] var1, int var2);

    public abstract void closeIO();

    @Override
    public int manageBufferForNewPosition(long newPosition, int readOrWrite, int size) {
        int bufferIndex = this.multiBuffer.getBufferIndexForPosition(newPosition, size);
        if (bufferIndex != -1) {
            ++nbBufferOk;
            return bufferIndex;
        }
        ++nbBufferNotOk;
        this.overlappingBuffers = this.getOverlappingBuffers(newPosition, this.bufferSize);
        bufferIndex = this.overlappingBuffers[0];
        if (this.nbBuffers > 1 && this.overlappingBuffers[1] != -1 && bufferIndex == this.currentBufferIndex) {
            bufferIndex = this.overlappingBuffers[1];
        }
        if (bufferIndex == -1) {
            bufferIndex = this.nextBufferIndex;
            this.nextBufferIndex = (this.nextBufferIndex + 1) % this.nbBuffers;
            if (bufferIndex == this.currentBufferIndex) {
                bufferIndex = this.nextBufferIndex;
                this.nextBufferIndex = (this.nextBufferIndex + 1) % this.nbBuffers;
            }
            this.flushBuffer(bufferIndex);
        }
        this.currentBufferIndex = bufferIndex;
        long length = this.getLength();
        if (readOrWrite == 1 && newPosition >= length) {
            String message = "End Of File reached - position = " + newPosition + " : Length = " + length;
            DLogger.error(message);
            throw new ODBRuntimeException(NeoDatisError.END_OF_FILE_REACHED.addParameter(newPosition).addParameter(length));
        }
        long nread = this.bufferSize;
        if (newPosition < length) {
            this.goToPosition(newPosition);
            nread = this.internalRead(this.multiBuffer.buffers[bufferIndex], this.bufferSize);
            this.multiBuffer.setCreationDate(bufferIndex, OdbTime.getCurrentTimeInMs());
        } else {
            this.goToPosition(newPosition);
        }
        long endPosition = -1L;
        endPosition = readOrWrite == 1 ? newPosition + nread : newPosition + (long)this.bufferSize;
        this.multiBuffer.setPositions(bufferIndex, newPosition, endPosition, 0);
        this.currentPositionWhenUsingBuffer = newPosition;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Creating buffer " + this.name + "-" + bufferIndex + " : [" + this.multiBuffer.bufferStartPosition[bufferIndex] + "," + this.multiBuffer.bufferEndPosition[bufferIndex] + "]");
        }
        return bufferIndex;
    }

    private int[] getOverlappingBuffers(long position, int size) {
        int i;
        long start1 = position;
        long end1 = position + (long)size;
        long start2 = 0L;
        long end2 = 0L;
        int[] indexes = new int[this.nbBuffers];
        int index = 0;
        for (i = 0; i < this.nbBuffers; ++i) {
            start2 = this.multiBuffer.bufferStartPosition[i];
            end2 = this.multiBuffer.bufferEndPosition[i];
            if (!(start1 >= start2 && start1 < end2 || start2 >= start1 && start2 < end1) && (start2 > start1 || end2 < end1)) continue;
            indexes[index++] = i;
            this.flushBuffer(i);
            ++nbFlushForOverlap;
        }
        for (i = index; i < this.nbBuffers; ++i) {
            indexes[i] = -1;
        }
        return indexes;
    }

    @Override
    public boolean isUsingbuffer() {
        return this.isUsingBuffer;
    }

    @Override
    public void setUseBuffer(boolean useBuffer) {
        if (this.isUsingBuffer && !useBuffer) {
            this.flushAllBuffers();
        }
        this.isUsingBuffer = useBuffer;
    }

    @Override
    public long getCurrentPosition() {
        if (!this.isUsingBuffer) {
            return this.currentPositionForDirectWrite;
        }
        return this.currentPositionWhenUsingBuffer;
    }

    @Override
    public void setCurrentWritePosition(long currentPosition) {
        if (this.isUsingBuffer) {
            if (this.currentPositionWhenUsingBuffer == currentPosition) {
                ++nbSamePositionForWrite;
                return;
            }
            this.currentPositionWhenUsingBuffer = currentPosition;
        } else {
            this.currentPositionForDirectWrite = currentPosition;
            this.goToPosition(currentPosition);
        }
    }

    @Override
    public void setCurrentReadPosition(long currentPosition) {
        if (this.isUsingBuffer) {
            if (this.currentPositionWhenUsingBuffer == currentPosition) {
                ++nbSamePositionForRead;
                return;
            }
            this.currentPositionWhenUsingBuffer = currentPosition;
            this.manageBufferForNewPosition(currentPosition, 1, 1);
        } else {
            this.currentPositionForDirectWrite = currentPosition;
            this.goToPosition(currentPosition);
        }
    }

    @Override
    public void writeByte(byte b) {
        if (!this.isUsingBuffer) {
            this.goToPosition(this.currentPositionForDirectWrite);
            this.internalWrite(b);
            ++this.currentPositionForDirectWrite;
            return;
        }
        int bufferIndex = this.multiBuffer.getBufferIndexForPosition(this.currentPositionWhenUsingBuffer, 1);
        if (bufferIndex == -1) {
            bufferIndex = this.manageBufferForNewPosition(this.currentPositionWhenUsingBuffer, 2, 1);
        }
        int positionInBuffer = (int)(this.currentPositionWhenUsingBuffer - this.multiBuffer.bufferStartPosition[bufferIndex]);
        this.multiBuffer.setByte(bufferIndex, positionInBuffer, b);
        ++this.currentPositionWhenUsingBuffer;
        if (this.currentPositionWhenUsingBuffer > this.ioDeviceLength) {
            this.ioDeviceLength = this.currentPositionWhenUsingBuffer;
        }
    }

    @Override
    public byte[] readBytesOld(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    @Override
    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        if (!this.isUsingBuffer) {
            this.goToPosition(this.currentPositionForDirectWrite);
            long realSize = this.internalRead(bytes, size);
            this.currentPositionForDirectWrite += realSize;
            return bytes;
        }
        if (size <= this.bufferSize) {
            return this.readBytes(bytes, 0, size);
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Data is larger than buffer size " + bytes.length + " > " + this.bufferSize + " : cutting the data");
        }
        int nbBuffersNeeded = bytes.length / this.bufferSize + 1;
        int currentStart = 0;
        int currentEnd = this.bufferSize;
        for (int i = 0; i < nbBuffersNeeded; ++i) {
            this.readBytes(bytes, currentStart, currentEnd);
            currentStart += this.bufferSize;
            if (currentEnd + this.bufferSize < bytes.length) {
                currentEnd += this.bufferSize;
                continue;
            }
            currentEnd = bytes.length;
        }
        return bytes;
    }

    public byte[] readBytes(byte[] bytes, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        int bufferIndex = this.manageBufferForNewPosition(this.currentPositionWhenUsingBuffer, 1, size);
        int start = (int)(this.currentPositionWhenUsingBuffer - this.multiBuffer.bufferStartPosition[bufferIndex]);
        byte[] buffer = this.multiBuffer.buffers[bufferIndex];
        System.arraycopy(buffer, start, bytes, startIndex, size);
        this.currentPositionWhenUsingBuffer += (long)size;
        return bytes;
    }

    @Override
    public byte readByte() {
        if (!this.isUsingBuffer) {
            this.goToPosition(this.currentPositionForDirectWrite);
            byte b = this.internalRead();
            ++this.currentPositionForDirectWrite;
            return b;
        }
        int bufferIndex = this.manageBufferForNewPosition(this.currentPositionWhenUsingBuffer, 1, 1);
        byte byt = this.multiBuffer.getByte(bufferIndex, (int)(this.currentPositionWhenUsingBuffer - this.multiBuffer.bufferStartPosition[bufferIndex]));
        ++this.currentPositionWhenUsingBuffer;
        return byt;
    }

    @Override
    public void writeBytes(byte[] bytes) {
        if (bytes.length > this.bufferSize) {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Data is larger than buffer size " + bytes.length + " > " + this.bufferSize + " : cutting the data");
            }
            int nbBuffersNeeded = bytes.length / this.bufferSize + 1;
            int currentStart = 0;
            int currentEnd = this.bufferSize;
            for (int i = 0; i < nbBuffersNeeded; ++i) {
                this.writeBytes(bytes, currentStart, currentEnd);
                currentStart += this.bufferSize;
                if (currentEnd + this.bufferSize < bytes.length) {
                    currentEnd += this.bufferSize;
                    continue;
                }
                currentEnd = bytes.length;
            }
        } else {
            this.writeBytes(bytes, 0, bytes.length);
        }
    }

    public void writeBytes(byte[] bytes, int startIndex, int endIndex) {
        if (!this.isUsingBuffer) {
            this.goToPosition(this.currentPositionForDirectWrite);
            this.internalWrite(bytes, bytes.length);
            this.currentPositionForDirectWrite += (long)bytes.length;
            return;
        }
        int lengthToCopy = endIndex - startIndex;
        ++nbWrites;
        totalWriteSize += (long)lengthToCopy;
        int bufferIndex = this.manageBufferForNewPosition(this.currentPositionWhenUsingBuffer, 2, lengthToCopy);
        int positionInBuffer = (int)(this.currentPositionWhenUsingBuffer - this.multiBuffer.bufferStartPosition[bufferIndex]);
        this.multiBuffer.writeBytes(bufferIndex, bytes, startIndex, positionInBuffer, lengthToCopy);
        positionInBuffer = positionInBuffer + lengthToCopy - 1;
        this.currentPositionWhenUsingBuffer += (long)lengthToCopy;
        if (this.currentPositionWhenUsingBuffer > this.ioDeviceLength) {
            this.ioDeviceLength = this.currentPositionWhenUsingBuffer;
        }
    }

    @Override
    public void flushAllBuffers() {
        for (int i = 0; i < this.nbBuffers; ++i) {
            this.flushBuffer(i);
        }
    }

    @Override
    public void flushBuffer(int bufferIndex) {
        byte[] buffer = this.multiBuffer.buffers[bufferIndex];
        if (buffer != null && this.multiBuffer.hasBeenUsedForWrite(bufferIndex)) {
            this.goToPosition(this.multiBuffer.bufferStartPosition[bufferIndex]);
            int bufferSizeToFlush = this.multiBuffer.maxPositionInBuffer[bufferIndex] + 1;
            this.internalWrite(buffer, bufferSizeToFlush);
            ++numberOfFlush;
            totalFlushSize += (long)bufferSizeToFlush;
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Flushing buffer " + this.name + "-" + bufferIndex + " : [" + this.multiBuffer.bufferStartPosition[bufferIndex] + ":" + this.multiBuffer.bufferEndPosition[bufferIndex] + "] - flush size=" + bufferSizeToFlush + "  flush number = " + numberOfFlush);
            }
            this.multiBuffer.clearBuffer(bufferIndex);
        } else {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("Flushing buffer " + this.name + "-" + bufferIndex + " : [" + this.multiBuffer.bufferStartPosition[bufferIndex] + ":" + this.multiBuffer.bufferEndPosition[bufferIndex] + "] - Nothing to flush!");
            }
            this.multiBuffer.clearBuffer(bufferIndex);
        }
    }

    public long getNumberOfFlush() {
        return numberOfFlush;
    }

    @Override
    public long getIoDeviceLength() {
        return this.ioDeviceLength;
    }

    @Override
    public void setIoDeviceLength(long ioDeviceLength) {
        this.ioDeviceLength = ioDeviceLength;
    }

    @Override
    public void close() {
        this.clear();
        this.closeIO();
    }

    @Override
    public void clear() {
        this.flushAllBuffers();
        this.multiBuffer.clear();
        this.multiBuffer = null;
        this.overlappingBuffers = null;
    }

    @Override
    public boolean isForTransaction() {
        return this.name != null && this.name.equals("transaction");
    }

    @Override
    public void enableAutomaticDelete(boolean yesOrNo) {
        this.enableAutomaticDelete = yesOrNo;
    }

    @Override
    public boolean automaticDeleteIsEnabled() {
        return this.enableAutomaticDelete;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Buffers=").append("currbuffer=").append(this.currentBufferIndex).append(" : \n");
        for (int i = 0; i < this.nbBuffers; ++i) {
            buffer.append(i).append(":[").append(this.multiBuffer.bufferStartPosition[i]).append(",").append(this.multiBuffer.bufferEndPosition[i]).append("] : write=").append(this.multiBuffer.hasBeenUsedForWrite(i)).append(" - when=").append(this.multiBuffer.getCreationDate(i));
            if (i + 1 >= this.nbBuffers) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    static {
        numberOfFlush = 0L;
        totalFlushSize = 0L;
        nbFlushForOverlap = 0;
    }
}

