/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl;

import java.net.Socket;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.IBufferedIO;
import org.neodatis.odb.core.layers.layer3.IIdManager;
import org.neodatis.odb.core.layers.layer3.IOFileParameter;
import org.neodatis.odb.core.layers.layer3.IOSocketParameter;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.IRefactorManager;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.server.layers.layer1.IClientObjectIntrospector;
import org.neodatis.odb.core.server.layers.layer3.engine.IMessageStreamer;
import org.neodatis.odb.core.server.layers.layer3.engine.IServerStorageEngine;
import org.neodatis.odb.core.server.transaction.ISessionManager;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.transaction.ITransaction;
import org.neodatis.odb.core.transaction.IWriteAction;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.layers.layer1.introspector.AndroidClassIntrospector;
import org.neodatis.odb.impl.core.layers.layer1.introspector.DefaultClassIntrospector;
import org.neodatis.odb.impl.core.layers.layer1.introspector.LocalObjectIntrospector;
import org.neodatis.odb.impl.core.layers.layer2.instance.LocalInstanceBuilder;
import org.neodatis.odb.impl.core.layers.layer2.instance.ODBClassPool;
import org.neodatis.odb.impl.core.layers.layer2.instance.ServerInstanceBuilder;
import org.neodatis.odb.impl.core.layers.layer3.buffer.MultiBufferedFileIO;
import org.neodatis.odb.impl.core.layers.layer3.engine.DefaultByteArrayConverter;
import org.neodatis.odb.impl.core.layers.layer3.engine.LocalObjectWriter;
import org.neodatis.odb.impl.core.layers.layer3.engine.LocalStorageEngine;
import org.neodatis.odb.impl.core.layers.layer3.engine.ObjectReader;
import org.neodatis.odb.impl.core.layers.layer3.oid.DefaultIdManager;
import org.neodatis.odb.impl.core.layers.layer3.refactor.DefaultRefactorManager;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.odb.impl.core.query.criteria.CollectionQueryResultAction;
import org.neodatis.odb.impl.core.server.layers.layer1.ClientObjectIntrospector;
import org.neodatis.odb.impl.core.server.layers.layer1.ServerObjectIntrospector;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ClientStorageEngine;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ServerObjectReader;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ServerObjectWriter;
import org.neodatis.odb.impl.core.server.layers.layer3.engine.ServerStorageEngine;
import org.neodatis.odb.impl.core.server.layers.layer3.oid.DefaultServerIdManager;
import org.neodatis.odb.impl.core.server.transaction.ServerSession;
import org.neodatis.odb.impl.core.server.transaction.SessionManager;
import org.neodatis.odb.impl.core.server.trigger.DefaultServerTriggerManager;
import org.neodatis.odb.impl.core.transaction.ClientSession;
import org.neodatis.odb.impl.core.transaction.DefaultTransaction;
import org.neodatis.odb.impl.core.transaction.DefaultWriteAction;
import org.neodatis.odb.impl.core.transaction.LocalSession;
import org.neodatis.odb.impl.core.trigger.DefaultTriggerManager;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbSystem;
import org.neodatis.tool.wrappers.io.MessageStreamerBuilder;
import org.neodatis.tool.wrappers.io.OdbFile;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class DefaultCoreProvider
implements ICoreProvider {
    private static IClassPool classPool = new ODBClassPool();
    private static IByteArrayConverter byteArrayConverter = new DefaultByteArrayConverter();
    private static IClassIntrospector classIntrospector = null;
    private static ISessionManager sessionManager = new SessionManager();
    private static Map<IStorageEngine, ITriggerManager> triggerManagers = new OdbHashMap<IStorageEngine, ITriggerManager>();

    @Override
    public void init2() {
        byteArrayConverter.init2();
        classIntrospector = this.osIsAndroid() ? new AndroidClassIntrospector() : new DefaultClassIntrospector();
        classIntrospector.init2();
        sessionManager.init2();
    }

    private boolean osIsAndroid() {
        String javaVendor = OdbSystem.getProperty("java.vendor");
        return javaVendor != null && javaVendor.equals("The Android Project");
    }

    @Override
    public void resetClassDefinitions() {
        classIntrospector.reset();
        classPool.reset();
    }

    @Override
    public IStorageEngine getClientStorageEngine(IBaseIdentification baseIdentification) {
        if (baseIdentification instanceof IOFileParameter) {
            return new LocalStorageEngine(baseIdentification);
        }
        if (baseIdentification instanceof IOSocketParameter) {
            IOSocketParameter p = (IOSocketParameter)baseIdentification;
            return new ClientStorageEngine(p);
        }
        throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_IO_TYPE.addParameter(baseIdentification.toString()));
    }

    @Override
    public IObjectWriter getClientObjectWriter(IStorageEngine engine) {
        return new LocalObjectWriter(engine);
    }

    @Override
    public IObjectReader getClientObjectReader(IStorageEngine engine) {
        return new ObjectReader(engine);
    }

    @Override
    public IObjectWriter getServerObjectWriter(IStorageEngine engine) {
        return new ServerObjectWriter(engine);
    }

    @Override
    public IObjectReader getServerObjectReader(IStorageEngine engine) {
        return new ServerObjectReader(engine);
    }

    @Override
    public IServerStorageEngine getServerStorageEngine(IBaseIdentification baseIdentification) {
        return new ServerStorageEngine(baseIdentification);
    }

    @Override
    public IByteArrayConverter getByteArrayConverter() {
        return byteArrayConverter;
    }

    @Override
    public IBufferedIO getIO(String name, IBaseIdentification parameters, int bufferSize) {
        if (parameters instanceof IOFileParameter) {
            IOFileParameter fileParameters = (IOFileParameter)parameters;
            OdbFile f = new OdbFile(fileParameters.getFileName());
            OdbFile fparent = f.getParentFile();
            if (fparent != null && !fparent.exists()) {
                DLogger.debug(fparent + " does not exist, creating it.");
                fparent.mkdirs();
            }
            return new MultiBufferedFileIO(OdbConfiguration.getNbBuffers(), name, fileParameters.getFileName(), fileParameters.canWrite(), bufferSize);
        }
        throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_IO_TYPE.addParameter(parameters.toString()));
    }

    @Override
    public IInstanceBuilder getLocalInstanceBuilder(IStorageEngine engine) {
        return new LocalInstanceBuilder(engine);
    }

    @Override
    public IInstanceBuilder getServerInstanceBuilder(IStorageEngine engine) {
        return new ServerInstanceBuilder(engine);
    }

    @Override
    public IObjectIntrospector getLocalObjectIntrospector(IStorageEngine engine) {
        return new LocalObjectIntrospector(engine);
    }

    @Override
    public IClientObjectIntrospector getClientObjectIntrospector(IStorageEngine engine, String connectionId) {
        return new ClientObjectIntrospector(engine, connectionId);
    }

    @Override
    public IObjectIntrospector getServerObjectIntrospector(IStorageEngine engine) {
        return new ServerObjectIntrospector(engine);
    }

    @Override
    public ITriggerManager getLocalTriggerManager(IStorageEngine engine) {
        ITriggerManager triggerManager = triggerManagers.get(engine);
        if (triggerManager != null) {
            return triggerManager;
        }
        triggerManager = new DefaultTriggerManager(engine);
        triggerManagers.put(engine, triggerManager);
        return triggerManager;
    }

    @Override
    public void removeLocalTriggerManager(IStorageEngine engine) {
        triggerManagers.remove(engine);
    }

    @Override
    public ITriggerManager getServerTriggerManager(IStorageEngine engine) {
        return new DefaultServerTriggerManager(engine);
    }

    @Override
    public IClassIntrospector getClassIntrospector() {
        return classIntrospector;
    }

    @Override
    public IIdManager getClientIdManager(IStorageEngine engine) {
        return new DefaultIdManager(engine.getObjectWriter(), engine.getObjectReader(), engine.getCurrentIdBlockPosition(), engine.getCurrentIdBlockNumber(), engine.getCurrentIdBlockMaxOid());
    }

    @Override
    public IIdManager getServerIdManager(IStorageEngine engine) {
        return new DefaultServerIdManager(engine.getObjectWriter(), engine.getObjectReader(), engine.getCurrentIdBlockPosition(), engine.getCurrentIdBlockNumber(), engine.getCurrentIdBlockMaxOid());
    }

    @Override
    public ISessionManager getClientServerSessionManager() {
        return sessionManager;
    }

    @Override
    public IWriteAction getWriteAction(long position, byte[] bytes) {
        return new DefaultWriteAction(position, bytes);
    }

    @Override
    public ITransaction getTransaction(ISession session, IFileSystemInterface fsi) {
        return new DefaultTransaction(session, fsi);
    }

    @Override
    public ISession getLocalSession(IStorageEngine engine) {
        return new LocalSession(engine);
    }

    @Override
    public ISession getClientSession(IStorageEngine engine) {
        return new ClientSession(engine);
    }

    @Override
    public ISession getServerSession(IStorageEngine engine, String sessionId) {
        return new ServerSession(engine, sessionId);
    }

    @Override
    public IRefactorManager getRefactorManager(IStorageEngine engine) {
        return new DefaultRefactorManager(engine);
    }

    @Override
    public IMatchingObjectAction getCollectionQueryResultAction(IStorageEngine engine, IQuery query, boolean inMemory, boolean returnObjects) {
        return new CollectionQueryResultAction(query, inMemory, engine, returnObjects, engine.getObjectReader().getInstanceBuilder());
    }

    @Override
    public OID getObjectOID(long objectOid, long classOid) {
        return new OdbObjectOID(objectOid);
    }

    @Override
    public OID getClassOID(long oid) {
        return new OdbClassOID(oid);
    }

    @Override
    public OID getExternalObjectOID(long objectOid, long classOid) {
        return new OdbObjectOID(objectOid);
    }

    @Override
    public OID getExternalClassOID(long oid) {
        return new OdbClassOID(oid);
    }

    @Override
    public IClassPool getClassPool() {
        return classPool;
    }

    @Override
    public IMessageStreamer getMessageStreamer(Socket socket) {
        return MessageStreamerBuilder.getMessageStreamer(socket);
    }

    @Override
    public IMessageStreamer getMessageStreamer(String host, int port, String name) {
        return MessageStreamerBuilder.getMessageStreamer(host, port, name);
    }
}

