/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl.singlevalue;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNodeOneValuePerKey;
import org.neodatis.btree.exception.DuplicatedKeyException;
import org.neodatis.btree.impl.AbstractBTreeNode;

public abstract class BTreeNodeSingleValuePerKey
extends AbstractBTreeNode
implements IBTreeNodeOneValuePerKey {
    public BTreeNodeSingleValuePerKey() {
    }

    public BTreeNodeSingleValuePerKey(IBTree btree) {
        super(btree);
    }

    @Override
    public Object getValueAt(int index) {
        return this.values[index];
    }

    @Override
    public void insertKeyAndValue(Comparable key, Object value) {
        int position = this.getPositionOfKey(key);
        int realPosition = 0;
        if (position >= 0) {
            throw new DuplicatedKeyException(String.valueOf(key));
        }
        realPosition = -position - 1;
        if (realPosition < this.nbKeys) {
            this.rightShiftFrom(realPosition, true);
        }
        this.keys[realPosition] = key;
        this.values[realPosition] = value;
        ++this.nbKeys;
    }

    @Override
    public Object search(Comparable key) {
        int position = this.getPositionOfKey(key);
        boolean keyIsHere = position > 0;
        int realPosition = -1;
        if (keyIsHere) {
            realPosition = position - 1;
            Object value = this.getValueAt(realPosition);
            return value;
        }
        if (this.isLeaf()) {
            return null;
        }
        realPosition = -position - 1;
        IBTreeNodeOneValuePerKey node = (IBTreeNodeOneValuePerKey)this.getChildAt(realPosition, true);
        return node.search(key);
    }
}

