/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Tree;
import junit.framework.TestCase;

public abstract class AbstractSparseTreeTest
extends TestCase {
    protected Tree<String, Integer> tree;
    protected Supplier<DirectedGraph<String, Integer>> graphFactory;
    protected Supplier<Integer> edgeFactory;

    public void testRemoveVertex() {
        this.tree.addVertex("A");
        this.tree.addEdge((Integer)this.edgeFactory.get(), "A", "B");
        this.tree.addEdge((Integer)this.edgeFactory.get(), "A", "C");
        this.tree.addEdge((Integer)this.edgeFactory.get(), "B", "E");
        this.tree.addEdge((Integer)this.edgeFactory.get(), "B", "F");
        this.tree.removeVertex("B");
    }

    public void testSimpleTree() {
        this.tree.addVertex("A");
        this.tree.addEdge((Integer)this.edgeFactory.get(), "A", "B");
        this.tree.addEdge((Integer)this.edgeFactory.get(), "A", "C");
    }

    public void testCreateLoop() {
        try {
            this.tree.addVertex("A");
            this.tree.addEdge((Integer)this.edgeFactory.get(), "A", "A");
            AbstractSparseTreeTest.fail((String)"should not be able to addChild(v,v)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tree.addEdge((Integer)this.edgeFactory.get(), "A", "B");
            this.tree.addEdge((Integer)this.edgeFactory.get(), "B", "A");
            AbstractSparseTreeTest.fail((String)"should not allow loop");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHeightAndDepth() {
        this.tree.addVertex("V0");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)0);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V0"), (int)0);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V0", "V1");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)1);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V1"), (int)1);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V0", "V2");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)1);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V2"), (int)1);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V1", "V4");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)2);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V4"), (int)2);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V2", "V3");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)2);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V3"), (int)2);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V2", "V5");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)2);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V5"), (int)2);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V4", "V6");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)3);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V6"), (int)3);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V4", "V7");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)3);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V7"), (int)3);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V3", "V8");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)3);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V8"), (int)3);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V6", "V9");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V9"), (int)4);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V4", "V10");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V10"), (int)3);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V4", "V11");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V11"), (int)3);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V4", "V12");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V12"), (int)3);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V6", "V13");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V13"), (int)4);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V10", "V14");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V14"), (int)4);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V13", "V15");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)5);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V15"), (int)5);
        this.tree.addEdge((Integer)this.edgeFactory.get(), "V13", "V16");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)5);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth("V16"), (int)5);
    }
}

