/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.shortestpath.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBFSDistanceLabeler
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestBFSDistanceLabeler.class);
    }

    protected void setUp() {
    }

    public void test() {
        UndirectedSparseMultigraph<Integer, Integer> graph = new UndirectedSparseMultigraph<Integer, Integer>();
        for (int i = 0; i < 6; ++i) {
            graph.addVertex(i);
        }
        int j = 0;
        graph.addEdge(Integer.valueOf(j++), 0, 1);
        graph.addEdge(Integer.valueOf(j++), 0, 5);
        graph.addEdge(Integer.valueOf(j++), 0, 3);
        graph.addEdge(Integer.valueOf(j++), 0, 4);
        graph.addEdge(Integer.valueOf(j++), 1, 5);
        graph.addEdge(Integer.valueOf(j++), 3, 4);
        graph.addEdge(Integer.valueOf(j++), 3, 2);
        graph.addEdge(Integer.valueOf(j++), 5, 2);
        Integer root = 0;
        BFSDistanceLabeler<Integer, Integer> labeler = new BFSDistanceLabeler<Integer, Integer>();
        labeler.labelDistances(graph, root);
        Assert.assertEquals((int)labeler.getPredecessors(root).size(), (int)0);
        Assert.assertEquals((int)labeler.getPredecessors(1).size(), (int)1);
        Assert.assertEquals((int)labeler.getPredecessors(2).size(), (int)2);
        Assert.assertEquals((int)labeler.getPredecessors(3).size(), (int)1);
        Assert.assertEquals((int)labeler.getPredecessors(4).size(), (int)1);
        Assert.assertEquals((int)labeler.getPredecessors(5).size(), (int)1);
        Assert.assertEquals((int)labeler.getDistance(graph, 0), (int)0);
        Assert.assertEquals((int)labeler.getDistance(graph, 1), (int)1);
        Assert.assertEquals((int)labeler.getDistance(graph, 2), (int)2);
        Assert.assertEquals((int)labeler.getDistance(graph, 3), (int)1);
        Assert.assertEquals((int)labeler.getDistance(graph, 4), (int)1);
        Assert.assertEquals((int)labeler.getDistance(graph, 5), (int)1);
    }
}

