/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.HITS;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHITS
extends TestCase {
    DirectedGraph<Number, Number> graph;

    public static Test suite() {
        return new TestSuite(TestHITS.class);
    }

    protected void setUp() {
        this.graph = new DirectedSparseMultigraph<Number, Number>();
        for (int i = 0; i < 5; ++i) {
            this.graph.addVertex(i);
        }
        int j = 0;
        this.graph.addEdge((Number)j++, 0, 1);
        this.graph.addEdge((Number)j++, 1, 2);
        this.graph.addEdge((Number)j++, 2, 3);
        this.graph.addEdge((Number)j++, 3, 0);
        this.graph.addEdge((Number)j++, 2, 1);
    }

    public void testRanker() {
        HITS<Number, Number> ranker = new HITS<Number, Number>((Graph<Number, Number>)this.graph);
        for (int i = 0; i < 10; ++i) {
            ranker.step();
            double auth_sum = 0.0;
            double hub_sum = 0.0;
            for (int j = 0; j < 5; ++j) {
                HITS.Scores score = (HITS.Scores)ranker.getVertexScore(j);
                auth_sum += score.authority * score.authority;
                hub_sum += score.hub * score.hub;
            }
            Assert.assertEquals((double)auth_sum, (double)1.0, (double)1.0E-4);
            Assert.assertEquals((double)hub_sum, (double)1.0, (double)1.0E-4);
        }
        ranker.evaluate();
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)0))).authority, (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)1))).authority, (double)0.8507, (double)0.001);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)2))).authority, (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)3))).authority, (double)0.5257, (double)0.001);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)0))).hub, (double)0.5257, (double)0.001);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)1))).hub, (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)2))).hub, (double)0.8507, (double)1.0E-4);
        Assert.assertEquals((double)((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)3))).hub, (double)0.0, (double)1.0E-4);
    }
}

