/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.DistanceStatistics;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;

public class KKLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    private double EPSILON = 0.1;
    private int currentIteration;
    private int maxIterations = 2000;
    private String status = "KKLayout";
    private double L;
    private double K = 1.0;
    private double[][] dm;
    private boolean adjustForGravity = true;
    private boolean exchangeVertices = true;
    private V[] vertices;
    private Point2D[] xydata;
    protected Distance<V> distance;
    protected double diameter;
    private double length_factor = 0.9;
    private double disconnected_multiplier = 0.5;

    public KKLayout(Graph<V, E> g) {
        this(g, new UnweightedShortestPath<V, E>(g));
    }

    public KKLayout(Graph<V, E> g, Distance<V> distance) {
        super(g);
        this.distance = distance;
    }

    public void setLengthFactor(double length_factor) {
        this.length_factor = length_factor;
    }

    public void setDisconnectedDistanceMultiplier(double disconnected_multiplier) {
        this.disconnected_multiplier = disconnected_multiplier;
    }

    public String getStatus() {
        return this.status + this.getSize();
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return this.currentIteration > this.maxIterations;
    }

    @Override
    public void initialize() {
        this.currentIteration = 0;
        if (this.graph != null && this.size != null) {
            double height = this.size.getHeight();
            double width = this.size.getWidth();
            int n = this.graph.getVertexCount();
            this.dm = new double[n][n];
            this.vertices = this.graph.getVertices().toArray();
            this.xydata = new Point2D[n];
            while (true) {
                try {
                    int index = 0;
                    for (Object v : this.graph.getVertices()) {
                        Object xyd = this.apply(v);
                        this.vertices[index] = v;
                        this.xydata[index] = xyd;
                        ++index;
                    }
                }
                catch (ConcurrentModificationException index) {
                    continue;
                }
                break;
            }
            this.diameter = DistanceStatistics.diameter(this.graph, this.distance, true);
            double L0 = Math.min(height, width);
            this.L = L0 / this.diameter * this.length_factor;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    Number d_ij = this.distance.getDistance(this.vertices[i], this.vertices[j]);
                    Number d_ji = this.distance.getDistance(this.vertices[j], this.vertices[i]);
                    double dist = this.diameter * this.disconnected_multiplier;
                    if (d_ij != null) {
                        dist = Math.min(d_ij.doubleValue(), dist);
                    }
                    if (d_ji != null) {
                        dist = Math.min(d_ji.doubleValue(), dist);
                    }
                    double d = dist;
                    this.dm[j][i] = d;
                    this.dm[i][j] = d;
                }
            }
        }
    }

    @Override
    public void step() {
        int i;
        ++this.currentIteration;
        double energy = this.calcEnergy();
        this.status = "Kamada-Kawai V=" + this.getGraph().getVertexCount() + "(" + this.getGraph().getVertexCount() + ") IT: " + this.currentIteration + " E=" + energy;
        int n = this.getGraph().getVertexCount();
        if (n == 0) {
            return;
        }
        double maxDeltaM = 0.0;
        int pm = -1;
        for (i = 0; i < n; ++i) {
            double deltam;
            if (this.isLocked(this.vertices[i]) || !(maxDeltaM < (deltam = this.calcDeltaM(i)))) continue;
            maxDeltaM = deltam;
            pm = i;
        }
        if (pm == -1) {
            return;
        }
        for (i = 0; i < 100; ++i) {
            double[] dxy = this.calcDeltaXY(pm);
            this.xydata[pm].setLocation(this.xydata[pm].getX() + dxy[0], this.xydata[pm].getY() + dxy[1]);
            double deltam = this.calcDeltaM(pm);
            if (deltam < this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity();
        }
        if (this.exchangeVertices && maxDeltaM < this.EPSILON) {
            energy = this.calcEnergy();
            for (i = 0; i < n - 1; ++i) {
                if (this.isLocked(this.vertices[i])) continue;
                for (int j = i + 1; j < n; ++j) {
                    double xenergy;
                    if (this.isLocked(this.vertices[j]) || !(energy > (xenergy = this.calcEnergyIfExchanged(i, j)))) continue;
                    double sx = this.xydata[i].getX();
                    double sy = this.xydata[i].getY();
                    this.xydata[i].setLocation(this.xydata[j]);
                    this.xydata[j].setLocation(sx, sy);
                    return;
                }
            }
        }
    }

    public void adjustForGravity() {
        Dimension d = this.getSize();
        double height = d.getHeight();
        double width = d.getWidth();
        double gx = 0.0;
        double gy = 0.0;
        for (int i = 0; i < this.xydata.length; ++i) {
            gx += this.xydata[i].getX();
            gy += this.xydata[i].getY();
        }
        double diffx = width / 2.0 - (gx /= (double)this.xydata.length);
        double diffy = height / 2.0 - (gy /= (double)this.xydata.length);
        for (int i = 0; i < this.xydata.length; ++i) {
            this.xydata[i].setLocation(this.xydata[i].getX() + diffx, this.xydata[i].getY() + diffy);
        }
    }

    @Override
    public void setSize(Dimension size) {
        if (!this.initialized) {
            this.setInitializer(new RandomLocationTransformer(size));
        }
        super.setSize(size);
    }

    public void setAdjustForGravity(boolean on) {
        this.adjustForGravity = on;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangeVertices(boolean on) {
        this.exchangeVertices = on;
    }

    public boolean getExchangeVertices() {
        return this.exchangeVertices;
    }

    private double[] calcDeltaXY(int m) {
        double dE_dxm = 0.0;
        double dE_dym = 0.0;
        double d2E_d2xm = 0.0;
        double d2E_dxmdym = 0.0;
        double d2E_dymdxm = 0.0;
        double d2E_d2ym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m][i];
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].getX() - this.xydata[i].getX();
            double dy = this.xydata[m].getY() - this.xydata[i].getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double ddd = d * d * d;
            dE_dxm += k_mi * (1.0 - l_mi / d) * dx;
            dE_dym += k_mi * (1.0 - l_mi / d) * dy;
            d2E_d2xm += k_mi * (1.0 - l_mi * dy * dy / ddd);
            d2E_dxmdym += k_mi * l_mi * dx * dy / ddd;
            d2E_d2ym += k_mi * (1.0 - l_mi * dx * dx / ddd);
        }
        d2E_dymdxm = d2E_dxmdym;
        double denomi = d2E_d2xm * d2E_d2ym - d2E_dxmdym * d2E_dymdxm;
        double deltaX = (d2E_dxmdym * dE_dym - d2E_d2ym * dE_dxm) / denomi;
        double deltaY = (d2E_dymdxm * dE_dxm - d2E_d2xm * dE_dym) / denomi;
        return new double[]{deltaX, deltaY};
    }

    private double calcDeltaM(int m) {
        double dEdxm = 0.0;
        double dEdym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m][i];
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].getX() - this.xydata[i].getX();
            double dy = this.xydata[m].getY() - this.xydata[i].getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double common = k_mi * (1.0 - l_mi / d);
            dEdxm += common * dx;
            dEdym += common * dy;
        }
        return Math.sqrt(dEdxm * dEdxm + dEdym * dEdym);
    }

    private double calcEnergy() {
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                double dist = this.dm[i][j];
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[i].getX() - this.xydata[j].getX();
                double dy = this.xydata[i].getY() - this.xydata[j].getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private double calcEnergyIfExchanged(int p, int q) {
        if (p >= q) {
            throw new RuntimeException("p should be < q");
        }
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                int ii = i;
                int jj = j;
                if (i == p) {
                    ii = q;
                }
                if (j == q) {
                    jj = p;
                }
                double dist = this.dm[i][j];
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[ii].getX() - this.xydata[jj].getX();
                double dy = this.xydata[ii].getY() - this.xydata[jj].getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    @Override
    public void reset() {
        this.currentIteration = 0;
    }
}

