/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.random.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEppsteinPowerLawGenerator
extends TestCase {
    Supplier<Graph<Integer, Number>> graphFactory;
    Supplier<Integer> vertexFactory;
    Supplier<Number> edgeFactory;

    public static Test suite() {
        return new TestSuite(TestEppsteinPowerLawGenerator.class);
    }

    protected void setUp() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new SparseMultigraph<Integer, Number>();
            }
        };
        this.vertexFactory = new Supplier<Integer>(){
            int count;

            public Integer get() {
                return this.count++;
            }
        };
        this.edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
    }

    public void testSimpleDirectedCase() {
        for (int r = 0; r < 10; ++r) {
            EppsteinPowerLawGenerator<Integer, Number> generator = new EppsteinPowerLawGenerator<Integer, Number>(this.graphFactory, this.vertexFactory, this.edgeFactory, 10, 40, r);
            generator.setSeed(2L);
            Object graph = generator.get();
            Assert.assertEquals((int)graph.getVertexCount(), (int)10);
            Assert.assertEquals((int)graph.getEdgeCount(), (int)40);
        }
    }
}

