/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters.impl;

import edu.uci.ics.jung.algorithms.filters.KNeighborhoodFilter;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestKNeighborhoodFilter
extends TestCase {
    DirectedGraph<Number, Number> graph;

    public static Test suite() {
        return new TestSuite(TestKNeighborhoodFilter.class);
    }

    protected void setUp() {
        this.graph = new DirectedSparseMultigraph<Number, Number>();
        for (int i = 0; i < 7; ++i) {
            this.graph.addVertex(i);
        }
        int j = 0;
        this.graph.addEdge((Number)j++, 0, 1);
        this.graph.addEdge((Number)j++, 0, 2);
        this.graph.addEdge((Number)j++, 2, 3);
        this.graph.addEdge((Number)j++, 2, 4);
        this.graph.addEdge((Number)j++, 3, 5);
        this.graph.addEdge((Number)j++, 5, 6);
        this.graph.addEdge((Number)j++, 5, 0);
        this.graph.addEdge((Number)j++, 3, 0);
        this.graph.addEdge((Number)j++, 6, 7);
    }

    public void testIn() {
        KNeighborhoodFilter filter = new KNeighborhoodFilter(0, 2, KNeighborhoodFilter.EdgeType.IN);
        Graph result = (Graph)filter.apply(this.graph);
        TestKNeighborhoodFilter.assertEquals((int)result.getVertexCount(), (int)4);
        TestKNeighborhoodFilter.assertEquals((int)result.getEdgeCount(), (int)5);
    }

    public void testOut() {
        KNeighborhoodFilter filter = new KNeighborhoodFilter(0, 2, KNeighborhoodFilter.EdgeType.OUT);
        Graph result = (Graph)filter.apply(this.graph);
        TestKNeighborhoodFilter.assertEquals((int)result.getVertexCount(), (int)5);
        TestKNeighborhoodFilter.assertEquals((int)result.getEdgeCount(), (int)5);
    }

    public void testInOut() {
        KNeighborhoodFilter filter = new KNeighborhoodFilter(0, 2, KNeighborhoodFilter.EdgeType.IN_OUT);
        Graph result = (Graph)filter.apply(this.graph);
        TestKNeighborhoodFilter.assertEquals((int)result.getVertexCount(), (int)7);
        TestKNeighborhoodFilter.assertEquals((int)result.getEdgeCount(), (int)8);
    }
}

