/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEdgeBetweennessClusterer
extends TestCase {
    Supplier<Graph<Integer, Number>> graphFactory;
    Supplier<Integer> vertexFactory;
    Supplier<Number> edgeFactory;

    public static Test suite() {
        return new TestSuite(TestEdgeBetweennessClusterer.class);
    }

    protected void setUp() {
        this.graphFactory = new Supplier<Graph<Integer, Number>>(){

            public Graph<Integer, Number> get() {
                return new SparseMultigraph<Integer, Number>();
            }
        };
        this.vertexFactory = new Supplier<Integer>(){
            int n = 0;

            public Integer get() {
                return this.n++;
            }
        };
        this.edgeFactory = new Supplier<Number>(){
            int n = 0;

            public Number get() {
                return this.n++;
            }
        };
    }

    public void testRanker() {
        SparseMultigraph<Integer, Integer> graph = new SparseMultigraph<Integer, Integer>();
        for (int i = 0; i < 10; ++i) {
            graph.addVertex(i + 1);
        }
        int j = 0;
        graph.addEdge(Integer.valueOf(j++), 1, 2);
        graph.addEdge(Integer.valueOf(j++), 1, 3);
        graph.addEdge(Integer.valueOf(j++), 2, 3);
        graph.addEdge(Integer.valueOf(j++), 5, 6);
        graph.addEdge(Integer.valueOf(j++), 5, 7);
        graph.addEdge(Integer.valueOf(j++), 6, 7);
        graph.addEdge(Integer.valueOf(j++), 8, 10);
        graph.addEdge(Integer.valueOf(j++), 7, 8);
        graph.addEdge(Integer.valueOf(j++), 7, 10);
        graph.addEdge(Integer.valueOf(j++), 3, 4);
        graph.addEdge(Integer.valueOf(j++), 4, 6);
        graph.addEdge(Integer.valueOf(j++), 4, 8);
        Assert.assertEquals((int)graph.getVertexCount(), (int)10);
        Assert.assertEquals((int)graph.getEdgeCount(), (int)12);
        EdgeBetweennessClusterer<Integer, Integer> clusterer = new EdgeBetweennessClusterer<Integer, Integer>(3);
        Set clusters = clusterer.apply(graph);
        Assert.assertEquals((int)clusters.size(), (int)3);
    }
}

