/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.LargeArrayTest;
import pl.edu.icm.jlargearrays.UnsignedByteLargeArray;

public class UnsignedByteLargeArrayTest
extends LargeArrayTest {
    public UnsignedByteLargeArrayTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testEmptyUnsignedByteLargeArray() {
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(0L);
        Assert.assertEquals((long)0L, (long)a.length());
        ArrayIndexOutOfBoundsException e = null;
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        a = new UnsignedByteLargeArray(0L, 1, true);
        Assert.assertEquals((long)0L, (long)a.length());
        Assert.assertTrue((boolean)a.isConstant());
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
    }

    @Test
    public void testUnsignedByteLargeArrayEqualsHashCode() {
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(10L);
        UnsignedByteLargeArray b = new UnsignedByteLargeArray(10L);
        Assert.assertTrue((boolean)a.equals(a));
        Assert.assertTrue((a.hashCode() == a.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == a.hashCode(1.0f) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals(b));
        Assert.assertTrue((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == b.hashCode(1.0f) ? 1 : 0) != 0);
        a.setUnsignedByte(0L, (short)1);
        Assert.assertFalse((boolean)a.equals(b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUnsignedByteLargeArrayApproximateHashCode() {
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(10L);
        UnsignedByteLargeArray b = new UnsignedByteLargeArray(10L);
        a.setUnsignedByte(0L, (short)1);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
        a = new UnsignedByteLargeArray(10L, 0, true);
        b = new UnsignedByteLargeArray(10L, 1, true);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() {
        Throwable throwable;
        ObjectInputStream in2;
        Throwable throwable2;
        ObjectOutputStream o2;
        Throwable throwable3;
        ByteArrayOutputStream bout;
        long size = 32L;
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(size);
        UnsignedByteLargeArray b = null;
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (UnsignedByteLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable in2) {
                    throwable2 = in2;
                    throw in2;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable in2) {
                                throwable2.addSuppressed(in2);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable o2) {
                throwable3 = o2;
                throw o2;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable o2) {
                            throwable3.addSuppressed(o2);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
        a = new UnsignedByteLargeArray(size, 2, true);
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (UnsignedByteLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
    }

    @Test
    public void testUnsignedByteLargeArrayConstant() {
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(10L, 225, true);
        Assert.assertTrue((boolean)a.isConstant());
        Assert.assertEquals((long)225L, (long)a.getUnsignedByte(0L));
        Assert.assertEquals((long)225L, (long)a.getUnsignedByte(a.length() - 1L));
        a.setUnsignedByte(0L, (short)200);
        Assert.assertEquals((long)200L, (long)a.getUnsignedByte(0L));
        Assert.assertFalse((boolean)a.isConstant());
    }

    @Test
    public void testUnsignedByteLargeArrayGetSet() {
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(10L);
        long idx = 5L;
        short val = 255;
        a.setUnsignedByte(idx, val);
        Assert.assertEquals((long)val, (long)a.getUnsignedByte(idx));
        idx = 6L;
        a.set(idx, val);
        Assert.assertEquals((long)val, (long)a.get(idx).shortValue());
    }

    @Test
    public void testUnsignedByteLargeArrayGetSetNative() {
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(10L);
        if (a.isLarge()) {
            long idx = 5L;
            byte val = -100;
            a.setToNative(idx, val);
            Assert.assertEquals((long)val, (long)a.getFromNative(idx).byteValue());
        }
    }

    @Test
    public void testUnsignedByteLargeArrayGetData() {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        long startPos = 2L;
        long endPos = 7L;
        long step = 2L;
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(data);
        byte[] res = a.getByteData(null, startPos, endPos, step);
        int idx = 0;
        for (long i = startPos; i < endPos; i += step) {
            Assert.assertEquals((long)data[(int)i], (long)res[idx++]);
        }
    }

    @Test
    public void testUnsignedByteLargeArrayGetShortData() {
        short[] data = new short[]{1, 2, 3, 4, 5, 6, 7, 80, 190, 255};
        long startPos = 2L;
        long endPos = 7L;
        long step = 2L;
        UnsignedByteLargeArray a = new UnsignedByteLargeArray(data);
        short[] res = a.getShortData(null, startPos, endPos, step);
        int idx = 0;
        for (long i = startPos; i < endPos; i += step) {
            Assert.assertEquals((long)data[(int)i], (long)res[idx++]);
        }
    }
}

