/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayStatistics;
import pl.edu.icm.jlargearrays.LargeArrayTest;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class LargeArrayStatisticsTest
extends LargeArrayTest {
    public LargeArrayStatisticsTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testMin() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.min(a);
        double min = a.getDouble(0L);
        for (long i = 1L; i < a.length(); ++i) {
            if (!(a.getDouble(i) < min)) continue;
            min = a.getDouble(i);
        }
        Assert.assertEquals((double)min, (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.min(a);
        Assert.assertEquals((double)2.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testMax() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.max(a);
        double max = a.getDouble(0L);
        for (long i = 1L; i < a.length(); ++i) {
            if (!(a.getDouble(i) > max)) continue;
            max = a.getDouble(i);
        }
        Assert.assertEquals((double)max, (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.max(a);
        Assert.assertEquals((double)2.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testSum() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.sum(a);
        double sum = 0.0;
        for (long i = 0L; i < a.length(); ++i) {
            sum += a.getDouble(i);
        }
        Assert.assertEquals((double)sum, (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.sum(a);
        Assert.assertEquals((double)20.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testSumKahan() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.sumKahan(a);
        double sum = 0.0;
        for (long i = 0L; i < a.length(); ++i) {
            sum += a.getDouble(i);
        }
        Assert.assertEquals((double)sum, (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.sumKahan(a);
        Assert.assertEquals((double)20.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testAvg() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.avg(a);
        double sum = 0.0;
        for (long i = 0L; i < a.length(); ++i) {
            sum += a.getDouble(i);
        }
        Assert.assertEquals((double)(sum / (double)a.length()), (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.avg(a);
        Assert.assertEquals((double)2.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testAvgKahan() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.avgKahan(a);
        double sum = 0.0;
        for (long i = 0L; i < a.length(); ++i) {
            sum += a.getDouble(i);
        }
        Assert.assertEquals((double)(sum / (double)a.length()), (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.avgKahan(a);
        Assert.assertEquals((double)2.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testStd() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.std(a);
        double sum = 0.0;
        double sum2 = 0.0;
        for (long i = 0L; i < a.length(); ++i) {
            sum += a.getDouble(i);
            sum2 += a.getDouble(i) * a.getDouble(i);
        }
        Assert.assertEquals((double)Math.sqrt(Math.max(0.0, (sum2 /= (double)a.length()) - (sum /= (double)a.length()) * sum)), (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.std(a);
        Assert.assertEquals((double)0.0, (double)res, (double)1.0E-6);
    }

    @Test
    public void testStdKahan() {
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        double res = LargeArrayStatistics.stdKahan(a);
        double sum = 0.0;
        double sum2 = 0.0;
        for (long i = 0L; i < a.length(); ++i) {
            sum += a.getDouble(i);
            sum2 += a.getDouble(i) * a.getDouble(i);
        }
        Assert.assertEquals((double)Math.sqrt(Math.max(0.0, (sum2 /= (double)a.length()) - (sum /= (double)a.length()) * sum)), (double)res, (double)1.0E-6);
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayStatistics.stdKahan(a);
        Assert.assertEquals((double)0.0, (double)res, (double)1.0E-6);
    }
}

