/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayArithmetics;
import pl.edu.icm.jlargearrays.LargeArrayTest;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class LargeArrayArithmeticsTest
extends LargeArrayTest {
    public LargeArrayArithmeticsTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testAdd() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray b = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.add(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) + b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        b = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.add(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) + ((ComplexFloatLargeArray)b).getComplexFloat(i)[0]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)((ComplexFloatLargeArray)b).getComplexFloat(i)[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        b = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, Float.valueOf(3.0f));
        res = LargeArrayArithmetics.add(a, b);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) + b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAxpy() {
        long i;
        LargeArray a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        LargeArray b = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, Float.valueOf(3.0f));
        LargeArray x = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        LargeArray res = LargeArrayArithmetics.axpy(a, x, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.DOUBLE), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getDouble(i) * x.getDouble(i) + (double)b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
        x = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.axpy(a, x, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)LargeArrayArithmetics.complexAdd(LargeArrayArithmetics.complexMult(new float[]{a.getFloat(i), 0.0f}, ((ComplexFloatLargeArray)x).getComplexFloat(i)), new float[]{b.getFloat(i), 0.0f})[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)LargeArrayArithmetics.complexAdd(LargeArrayArithmetics.complexMult(new float[]{a.getFloat(i), 0.0f}, ((ComplexFloatLargeArray)x).getComplexFloat(i)), new float[]{b.getFloat(i), 0.0f})[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        x = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, Float.valueOf(3.0f));
        res = LargeArrayArithmetics.axpy(a, x, b);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) * x.getFloat(i) + b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDiff() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray b = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.diff(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) - b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        b = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.diff(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) - ((ComplexFloatLargeArray)b).getComplexFloat(i)[0]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)(-((ComplexFloatLargeArray)b).getComplexFloat(i)[1]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        b = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, Float.valueOf(3.0f));
        res = LargeArrayArithmetics.diff(a, b);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) - b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testMult() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray b = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.mult(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) * b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        b = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.mult(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) * ((ComplexFloatLargeArray)b).getComplexFloat(i)[0]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)(a.getFloat(i) * ((ComplexFloatLargeArray)b).getComplexFloat(i)[1]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        b = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, Float.valueOf(3.0f));
        res = LargeArrayArithmetics.mult(a, b);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) * b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testDiv() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray b = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.div(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) / b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        b = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.div(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            double r = ((ComplexFloatLargeArray)b).getComplexFloat(i)[0] * ((ComplexFloatLargeArray)b).getComplexFloat(i)[0] + ((ComplexFloatLargeArray)b).getComplexFloat(i)[1] * ((ComplexFloatLargeArray)b).getComplexFloat(i)[1];
            Assert.assertEquals((double)((double)(a.getFloat(i) * ((ComplexFloatLargeArray)b).getComplexFloat(i)[0]) / r), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)((double)(-a.getFloat(i) * ((ComplexFloatLargeArray)b).getComplexFloat(i)[1]) / r), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        b = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, Float.valueOf(3.0f));
        res = LargeArrayArithmetics.div(a, b);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)(a.getFloat(i) / b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPow() {
        long i;
        double n = 2.2;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.pow(a, n);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.pow(a.getDouble(i2), n), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.pow(a, n);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexPow(elem_a, n);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.pow(a, n);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.pow(a.getFloat(i), n), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testPow2() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray b = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.pow(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)FastMath.pow((double)a.getFloat(i), (double)b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.DOUBLE, 10L);
        b = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.pow(a, b);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertArrayEquals((float[])LargeArrayArithmetics.complexPow(new float[]{a.getFloat(i), 0.0f}, ((ComplexFloatLargeArray)b).getComplexFloat(i)), (float[])((ComplexFloatLargeArray)res).getComplexFloat(i), (float)1.0E-6f);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, 2);
        b = LargeArrayUtils.createConstant(LargeArrayType.FLOAT, 10L, 3);
        res = LargeArrayArithmetics.pow(a, b);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)FastMath.pow((double)a.getFloat(i), (double)b.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testNeg() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray res = LargeArrayArithmetics.neg(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.BYTE), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((long)(-a.getByte(i2)), (long)res.getByte(i2));
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.neg(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            Assert.assertEquals((double)(-elem_a[0]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)(-elem_a[1]), (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.neg(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.BYTE), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((long)(-a.getByte(i)), (long)res.getByte(i));
        }
    }

    @Test
    public void testSqrt() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.sqrt(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.sqrt(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.sqrt(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexSqrt(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.sqrt(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.sqrt(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testLog() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.log(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.log(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.log(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexLog(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.log(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.log(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testLog10() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.log10(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.log10(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.log10(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexLog10(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.log10(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.log10(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testExp() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.exp(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.exp(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.exp(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexExp(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.exp(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.exp(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAbs() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.abs(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.abs(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.abs(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            Assert.assertEquals((double)LargeArrayArithmetics.complexAbs(elem_a), (double)res.getFloat(i), (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.abs(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.BYTE), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((long)a.getByte(i), (long)res.getByte(i));
        }
    }

    @Test
    public void testSin() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.sin(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.sin(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.sin(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexSin(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.sin(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.sin(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testCos() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.cos(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.cos(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.cos(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexCos(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.cos(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.cos(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testTan() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.tan(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.tan(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.tan(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexTan(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.tan(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.tan(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAsin() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.asin(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.asin(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.asin(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexAsin(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.asin(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.asin(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAcos() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.acos(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.acos(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.acos(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexAcos(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.acos(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.acos(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testAtan() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.FLOAT, 10L);
        LargeArray res = LargeArrayArithmetics.atan(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (long i2 = 0L; i2 < a.length(); ++i2) {
            Assert.assertEquals((double)Math.atan(a.getDouble(i2)), (double)res.getFloat(i2), (double)1.0E-6);
        }
        a = LargeArrayUtils.generateRandom(LargeArrayType.COMPLEX_FLOAT, 10L);
        res = LargeArrayArithmetics.atan(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.COMPLEX_FLOAT), (Object)((Object)res.getType()));
        ComplexFloatLargeArray ac = (ComplexFloatLargeArray)a;
        for (i = 0L; i < a.length(); ++i) {
            float[] elem_a = ac.getComplexFloat(i);
            float[] elem_res = LargeArrayArithmetics.complexAtan(elem_a);
            Assert.assertEquals((double)elem_res[0], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[0], (double)1.0E-6);
            Assert.assertEquals((double)elem_res[1], (double)((ComplexFloatLargeArray)res).getComplexFloat(i)[1], (double)1.0E-6);
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.atan(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.FLOAT), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((double)Math.atan(a.getFloat(i)), (double)res.getFloat(i), (double)1.0E-6);
        }
    }

    @Test
    public void testSignum() {
        long i;
        LargeArray a = LargeArrayUtils.generateRandom(LargeArrayType.BYTE, 10L);
        LargeArray res = LargeArrayArithmetics.signum(a);
        Assert.assertEquals((Object)((Object)LargeArrayType.BYTE), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((long)((byte)Math.signum(a.getByte(i))), (long)res.getByte(i));
        }
        a = LargeArrayUtils.createConstant(LargeArrayType.BYTE, 10L, (byte)2);
        res = LargeArrayArithmetics.signum(a);
        Assert.assertTrue((boolean)res.isConstant());
        Assert.assertEquals((Object)((Object)LargeArrayType.BYTE), (Object)((Object)res.getType()));
        for (i = 0L; i < a.length(); ++i) {
            Assert.assertEquals((long)((byte)Math.signum(a.getByte(i))), (long)res.getByte(i));
        }
    }
}

