/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArrayTest;

public class ComplexFloatLargeArrayTest
extends LargeArrayTest {
    public ComplexFloatLargeArrayTest(boolean useOffHeapMemory) {
        super(useOffHeapMemory);
    }

    @Test
    public void testEmptyComplexFloatLargeArray() {
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(0L);
        Assert.assertEquals((long)0L, (long)a.length());
        ArrayIndexOutOfBoundsException e = null;
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        a = new ComplexFloatLargeArray(0L, new float[]{1.0f, 2.0f}, true);
        Assert.assertEquals((long)0L, (long)a.length());
        Assert.assertTrue((boolean)a.isConstant());
        try {
            a.get_safe(0L);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
        e = null;
        try {
            a.set_safe(0L, 0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            e = ex;
        }
        Assert.assertTrue((boolean)(e instanceof ArrayIndexOutOfBoundsException));
    }

    @Test
    public void testComplexFloatLargeArrayEqualsHashCode() {
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(10L);
        ComplexFloatLargeArray b = new ComplexFloatLargeArray(10L);
        Assert.assertTrue((boolean)a.equals(a));
        Assert.assertTrue((a.hashCode() == a.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == a.hashCode(1.0f) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a.equals(b));
        Assert.assertTrue((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((a.hashCode() == b.hashCode(1.0f) ? 1 : 0) != 0);
        a.set(0L, new float[]{1.0f, 2.0f});
        Assert.assertFalse((boolean)a.equals(b));
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testComplexFloatLargeArrayApproximateHashCode() {
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(10L);
        ComplexFloatLargeArray b = new ComplexFloatLargeArray(10L);
        a.setComplexFloat(0L, new float[]{1.0f, 2.0f});
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
        a = new ComplexFloatLargeArray(10L, new float[]{1.0f, 2.0f}, true);
        b = new ComplexFloatLargeArray(10L, new float[]{2.0f, 3.0f}, true);
        Assert.assertTrue((a.hashCode(0.0f) == b.hashCode(0.0f) ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode(1.0f) == b.hashCode(1.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() {
        Throwable throwable;
        ObjectInputStream in2;
        Throwable throwable2;
        ObjectOutputStream o2;
        Throwable throwable3;
        ByteArrayOutputStream bout;
        long size = 32L;
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(size);
        ComplexFloatLargeArray b = null;
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (ComplexFloatLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable in2) {
                    throwable2 = in2;
                    throw in2;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable in2) {
                                throwable2.addSuppressed(in2);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable o2) {
                throwable3 = o2;
                throw o2;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable o2) {
                            throwable3.addSuppressed(o2);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
        a = new ComplexFloatLargeArray(size, new float[]{2.0f, 3.0f}, true);
        try {
            bout = new ByteArrayOutputStream();
            throwable3 = null;
            try {
                o2 = new ObjectOutputStream(bout);
                throwable2 = null;
                try {
                    o2.writeObject(a);
                    o2.close();
                    in2 = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
                    throwable = null;
                    try {
                        b = (ComplexFloatLargeArray)in2.readObject();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (in2 != null) {
                            if (throwable != null) {
                                try {
                                    in2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                in2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (o2 != null) {
                        if (throwable2 != null) {
                            try {
                                o2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            o2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (bout != null) {
                    if (throwable3 != null) {
                        try {
                            bout.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        bout.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertTrue((boolean)a.equals(b));
    }

    @Test
    public void testComplexFloatLargeArrayConstant() {
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(10L, new float[]{2.5f, 1.5f}, true);
        Assert.assertTrue((boolean)a.isConstant());
        Assert.assertEquals((double)2.5, (double)a.getComplexFloat(0L)[0], (double)1.0E-6);
        Assert.assertEquals((double)1.5, (double)a.getComplexFloat(0L)[1], (double)1.0E-6);
        Assert.assertEquals((double)2.5, (double)a.getComplexFloat(a.length - 1L)[0], (double)1.0E-6);
        Assert.assertEquals((double)1.5, (double)a.getComplexFloat(a.length - 1L)[1], (double)1.0E-6);
        a.setComplexFloat(0L, new float[]{3.5f, 4.5f});
        Assert.assertEquals((double)3.5, (double)a.getComplexFloat(0L)[0], (double)1.0E-6);
        Assert.assertEquals((double)4.5, (double)a.getComplexFloat(0L)[1], (double)1.0E-6);
        Assert.assertFalse((boolean)a.isConstant());
    }

    @Test
    public void testComplexFloatLargeArrayGetSet() {
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(10L);
        long idx = 5L;
        float[] val = new float[]{3.4f, -3.7f};
        a.setComplexFloat(idx, val);
        Assert.assertEquals((double)val[0], (double)a.getComplexFloat(idx)[0], (double)1.0E-6);
        Assert.assertEquals((double)val[1], (double)a.getComplexFloat(idx)[1], (double)1.0E-6);
        idx = 6L;
        a.set(idx, val);
        Assert.assertEquals((double)val[0], (double)a.get(idx)[0], (double)1.0E-6);
        Assert.assertEquals((double)val[1], (double)a.get(idx)[1], (double)1.0E-6);
    }

    @Test
    public void testComplexFloatLargeArrayGetSetNative() {
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(10L);
        if (a.isLarge()) {
            long idx = 5L;
            float[] val = new float[]{3.4f, -3.7f};
            a.setToNative(idx, val);
            Assert.assertEquals((double)val[0], (double)a.getFromNative(idx)[0], (double)1.0E-6);
            Assert.assertEquals((double)val[1], (double)a.getFromNative(idx)[1], (double)1.0E-6);
        }
    }

    @Test
    public void testComplexFloatLargeArrayGetData() {
        float[] data = new float[]{1.1f, 2.2f, 3.3f, 4.4f, 5.5f, 6.6f, 7.7f, 8.8f, 9.9f, 10.1f};
        int startPos = 1;
        int endPos = 5;
        int step = 2;
        ComplexFloatLargeArray a = new ComplexFloatLargeArray(data);
        float[] res = a.getComplexData(null, startPos, endPos, step);
        int idx = 0;
        for (int i = startPos; i < endPos; i += step) {
            Assert.assertEquals((double)data[2 * i], (double)res[2 * idx], (double)1.0E-6);
            Assert.assertEquals((double)data[2 * i + 1], (double)res[2 * idx + 1], (double)1.0E-6);
            ++idx;
        }
    }
}

