/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.transform;

import com.jogamp.opengl.GL;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.Transformer;

public class TranslateDrawable
implements Transformer {
    protected AbstractDrawable drawable;
    protected boolean reverse;

    public TranslateDrawable(AbstractDrawable drawable, boolean reverse) {
        this.reverse = reverse;
        this.drawable = drawable;
    }

    @Override
    public void execute(GL gl) {
        BoundingBox3d bounds;
        if (this.drawable != null && (bounds = this.drawable.getBounds()) != null) {
            Coord3d center = bounds.getCenter();
            this.translateTo(gl, center, this.reverse);
        }
    }

    public void translateTo(GL gl, Coord3d center, boolean reverse) {
        if (gl.isGLES()) {
            float reverseCoef = reverse ? -1.0f : 1.0f;
            GLES2CompatUtils.glTranslatef(reverseCoef * center.x / 2.0f, reverseCoef * center.y / 2.0f, reverseCoef * center.z / 2.0f);
        } else if (reverse) {
            gl.getGL2().glTranslatef(-center.x / 2.0f, -center.y / 2.0f, -center.z / 2.0f);
        } else {
            gl.getGL2().glTranslatef(center.x / 2.0f, center.y / 2.0f, center.z / 2.0f);
        }
    }

    @Override
    public Coord3d compute(Coord3d input) {
        BoundingBox3d bounds;
        if (this.drawable != null && (bounds = this.drawable.getBounds()) != null) {
            Coord3d center = bounds.getCenter();
            if (this.reverse) {
                return input.sub(center.div(2.0f));
            }
            return input.add(center.div(2.0f));
        }
        return null;
    }

    public AbstractDrawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(AbstractDrawable drawable) {
        this.drawable = drawable;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public String toString() {
        return "(TranslateDrawable)" + this.drawable;
    }
}

