/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.legends.colorbars;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.awt.image.BufferedImage;
import org.jzy3d.chart.Chart;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.maths.Dimension;
import org.jzy3d.plot2d.primitive.AWTColorbarImageGenerator;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;
import org.jzy3d.plot3d.rendering.legends.AWTLegend;
import org.jzy3d.plot3d.rendering.legends.colorbars.IColorbarLegend;

public class AWTColorbarLegend
extends AWTLegend
implements IColorbarLegend {
    protected ITickProvider provider;
    protected ITickRenderer renderer;

    public AWTColorbarLegend(AbstractDrawable parent, Chart chart) {
        this(parent, chart.getView().getAxe().getLayout());
    }

    public AWTColorbarLegend(AbstractDrawable parent, IAxeLayout layout) {
        this(parent, layout.getZTickProvider(), layout.getZTickRenderer(), layout.getMainColor(), layout.getMainColor().negative());
    }

    public AWTColorbarLegend(AbstractDrawable parent, IAxeLayout layout, Color foreground) {
        this(parent, layout.getZTickProvider(), layout.getZTickRenderer(), foreground, null);
    }

    public AWTColorbarLegend(AbstractDrawable parent, IAxeLayout layout, Color foreground, Color background) {
        this(parent, layout.getZTickProvider(), layout.getZTickRenderer(), foreground, background);
    }

    public AWTColorbarLegend(AbstractDrawable parent, ITickProvider provider, ITickRenderer renderer) {
        this(parent, provider, renderer, Color.BLACK, Color.WHITE);
    }

    public AWTColorbarLegend(AbstractDrawable parent, ITickProvider provider, ITickRenderer renderer, Color foreground, Color background) {
        super(parent, foreground, background);
        this.provider = provider;
        this.renderer = renderer;
        this.minimumDimension = new Dimension(100, 100);
        this.initImageGenerator(parent, provider, renderer);
    }

    public void initImageGenerator(AbstractDrawable parent, ITickProvider provider, ITickRenderer renderer) {
        IMultiColorable mc;
        if (parent != null && parent instanceof IMultiColorable && (mc = (IMultiColorable)((Object)parent)).getColorMapper() != null) {
            this.imageGenerator = new AWTColorbarImageGenerator(mc.getColorMapper(), provider, renderer);
        }
    }

    @Override
    public void render(GL gl, GLU glu) {
        gl.glEnable(3042);
        super.render(gl, glu);
    }

    @Override
    public BufferedImage toImage(int width, int height) {
        if (this.imageGenerator != null) {
            this.setGeneratorColors();
            return this.imageGenerator.toImage(Math.max(width - 25, 1), Math.max(height - 25, 1));
        }
        return null;
    }
}

