/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.textured;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Quad;
import org.jzy3d.plot3d.primitives.textured.ITranslucent;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;

public class TranslucentQuad
extends Quad
implements ITranslucent {
    protected float alpha = 1.0f;

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            if (this.facestatus) {
                gl.getGL2().glPolygonMode(1032, 6914);
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                gl.getGL2().glBegin(7);
                for (Point p : this.points) {
                    if (this.mapper != null) {
                        Color c = this.mapper.getColor(p.xyz);
                        this.callWithAlphaFactor(gl, c, this.alpha);
                    } else {
                        this.callWithAlphaFactor(gl, p.rgb, this.alpha);
                    }
                    gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                }
                gl.getGL2().glEnd();
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                gl.getGL2().glPolygonMode(1032, 6913);
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
                this.callWithAlphaFactor(gl, this.wfcolor, this.alpha);
                gl.glLineWidth(this.wfwidth);
                gl.getGL2().glBegin(7);
                for (Point p : this.points) {
                    gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                }
                gl.getGL2().glEnd();
                gl.glDisable(32823);
            }
        } else {
            if (this.facestatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                GLES2CompatUtils.glBegin(7);
                for (Point p : this.points) {
                    if (this.mapper != null) {
                        Color c = this.mapper.getColor(p.xyz);
                        this.callWithAlphaFactor(gl, c, this.alpha);
                    } else {
                        this.callWithAlphaFactor(gl, p.rgb, this.alpha);
                    }
                    GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                }
                GLES2CompatUtils.glEnd();
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                gl.glEnable(32823);
                gl.glPolygonOffset(1.0f, 1.0f);
                this.callWithAlphaFactor(gl, this.wfcolor, this.alpha);
                gl.glLineWidth(this.wfwidth);
                GLES2CompatUtils.glBegin(7);
                for (Point p : this.points) {
                    GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                }
                GLES2CompatUtils.glEnd();
                gl.glDisable(32823);
            }
        }
    }

    @Override
    public void setAlphaFactor(float a) {
        this.alpha = a;
    }
}

