/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot3d.primitives.Croppable;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;

public class CroppableLineStrip
extends LineStrip
implements Croppable {
    boolean[] filter;

    @Override
    public void filter(BoundingBox3d bounds) {
        this.filter = new boolean[this.points.size()];
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i] = bounds.contains(((Point)this.points.get((int)i)).xyz);
        }
    }

    @Override
    public void resetFilter() {
        this.filter = null;
    }

    @Override
    public void drawLineGL2(GL gl) {
        gl.getGL2().glBegin(3);
        gl.getGL2().glLineWidth(this.wfwidth);
        if (this.filter == null) {
            this.doDrawAllLines(gl);
        } else {
            this.doDrawLinesFiltered(gl);
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void drawPointsGL2(GL gl) {
        gl.getGL2().glBegin(0);
        if (this.filter == null) {
            this.doDrawAllPoints(gl);
        } else {
            this.doDrawPointsFiltered(gl);
        }
        gl.getGL2().glEnd();
    }

    private void doDrawAllLines(GL gl) {
        if (this.wfcolor == null) {
            for (Point p : this.points) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        } else {
            for (Point p : this.points) {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        }
    }

    private void doDrawLinesFiltered(GL gl) {
        for (int i = 0; i < this.filter.length; ++i) {
            if (!this.filter[i]) continue;
            Point p = (Point)this.points.get(i);
            if (this.wfcolor == null) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
        }
    }

    private void doDrawAllPoints(GL gl) {
        for (Point p : this.points) {
            if (this.wfcolor == null) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
        }
    }

    private void doDrawPointsFiltered(GL gl) {
        for (int i = 0; i < this.filter.length; ++i) {
            if (!this.filter[i]) continue;
            Point p = (Point)this.points.get(i);
            if (this.wfcolor == null) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
        }
    }
}

