/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Utils {
    public static String num2str(char parseMode, double num, int precision) {
        return String.format("%." + precision + parseMode, new Double(num));
    }

    public static String num2str(char parseMode, double num) {
        return String.format("%" + parseMode, new Double(num));
    }

    public static String num2str(double num, int precision) {
        return Utils.num2str('g', num, precision);
    }

    public static String num2str(double num) {
        return Double.toString(num);
    }

    public static String dat2str(Date date) {
        return Utils.dat2str(date, "dd/MM/yyyy HH:mm:ss");
    }

    public static String dat2str(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault());
        return formatter.format(date);
    }

    public static long dat2num(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static Date num2dat(long value) {
        return new Date(value);
    }

    public static String time2str(long milli) {
        StringBuilder buf = new StringBuilder(20);
        String sgn = "";
        if (milli < 0L) {
            sgn = "-";
            milli = Math.abs(milli);
        }
        Utils.append(buf, sgn, 0, milli / 3600000L);
        Utils.append(buf, ":", 2, milli % 3600000L / 60000L);
        Utils.append(buf, ":", 2, milli % 60000L / 1000L);
        Utils.append(buf, ".", 3, milli % 1000L);
        return buf.toString();
    }

    private static void append(StringBuilder tgt, String pfx, int dgt, long val) {
        tgt.append(pfx);
        if (dgt > 1) {
            int pad = dgt - 1;
            for (long xa = val; xa > 9L && pad > 0; --pad, xa /= 10L) {
            }
            for (int xa = 0; xa < pad; ++xa) {
                tgt.append('0');
            }
        }
        tgt.append(val);
    }

    public static String blanks(int length) {
        String b = "";
        for (int i = 0; i < length; ++i) {
            b = b + " ";
        }
        return b;
    }

    public static double[] abs(double[] values) {
        double[] output = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            output[i] = Math.abs(values[i]);
        }
        return output;
    }

    public static double sum(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        double total = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            total += values[i];
        }
        return total;
    }

    public static int sum(int[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        int total = 0;
        for (int i = 0; i < values.length; ++i) {
            total += values[i];
        }
        return total;
    }

    public static double[] vector(double min, double max, int nstep) {
        double step = (max - min) / (double)(nstep - 1);
        double[] grid = new double[nstep];
        for (int i = 0; i < grid.length; ++i) {
            grid[i] = min + (double)i * step;
        }
        return grid;
    }

    public static double[] vector(double min, double max) {
        return Utils.vector(min, max, (int)Math.abs(max - min) + 1);
    }

    public static int[] vector(int min, int max, int nstep) {
        int step = (max - min) / (nstep - 1);
        int[] grid = new int[nstep];
        for (int i = 0; i < grid.length; ++i) {
            grid[i] = min + i * step;
        }
        return grid;
    }

    public static int[] vector(int min, int max) {
        return Utils.vector(min, max, Math.abs(max - min) + 1);
    }

    public static Date min(Date[] dates) {
        if (dates.length == 0) {
            throw new RuntimeException("input array is empty");
        }
        Date min = new Date(Long.MAX_VALUE);
        for (int i = 0; i < dates.length; ++i) {
            if (!min.after(dates[i])) continue;
            min = dates[i];
        }
        return min;
    }

    public static Date max(Date[] dates) {
        if (dates.length == 0) {
            throw new RuntimeException("input array is empty");
        }
        Date max = new Date(-9223372036854775807L);
        for (int i = 0; i < dates.length; ++i) {
            if (!max.before(dates[i])) continue;
            max = dates[i];
        }
        return max;
    }

    public static Date str2date(String string) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH);
        Date date = format.parse(string);
        return date;
    }
}

