/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Vector3d;

public class Angle3d {
    private float x1;
    private float x2;
    private float x3;
    private float y1;
    private float y2;
    private float y3;
    private float z1;
    private float z2;
    private float z3;

    public Angle3d(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.y1 = y1;
        this.y2 = y2;
        this.y3 = y3;
        this.z1 = z1;
        this.z2 = z2;
        this.z3 = z3;
    }

    public Angle3d(Coord3d p1, Coord3d p2, Coord3d p3) {
        this.x1 = p1.x;
        this.x2 = p2.x;
        this.x3 = p3.x;
        this.y1 = p1.y;
        this.y2 = p2.y;
        this.y3 = p3.y;
        this.z1 = p1.z;
        this.z2 = p2.z;
        this.z3 = p3.z;
    }

    public float sin() {
        Coord3d c2 = new Coord3d(this.x2, this.y2, this.z2);
        Vector3d v1 = new Vector3d(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
        Vector3d v3 = new Vector3d(this.x3, this.y3, this.z3, this.x2, this.y2, this.z2);
        Coord3d c4 = v1.cross(v3).add(c2);
        Vector3d v4 = new Vector3d(c4, c2);
        return (float)(c4.z >= 0.0f ? 1 : -1) * v4.norm() / (v1.norm() * v3.norm());
    }

    public float cos() {
        Vector3d v1 = new Vector3d(this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
        Vector3d v3 = new Vector3d(this.x3, this.y3, this.z3, this.x2, this.y2, this.z2);
        return v1.dot(v3) / (v1.norm() * v3.norm());
    }

    public float angle() {
        double lenP1P3 = Math.sqrt(Math.pow(this.x1 - this.x3, 2.0) + Math.pow(this.y1 - this.y3, 2.0) + Math.pow(this.z1 - this.z3, 2.0));
        double lenP1P2 = Math.sqrt(Math.pow(this.x1 - this.x2, 2.0) + Math.pow(this.y1 - this.y2, 2.0) + Math.pow(this.z1 - this.z2, 2.0));
        double lenP3P2 = Math.sqrt(Math.pow(this.x3 - this.x2, 2.0) + Math.pow(this.y3 - this.y2, 2.0) + Math.pow(this.z3 - this.z2, 2.0));
        double numerator = Math.pow(lenP1P2, 2.0) + Math.pow(lenP3P2, 2.0) - Math.pow(lenP1P3, 2.0);
        double denominator = 2.0 * lenP1P2 * lenP3P2;
        return (float)Math.acos(numerator / denominator);
    }
}

