/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io.matlab;

import com.jmatio.io.MatFileReader;
import com.jmatio.types.MLNumericArray;
import com.jogamp.opengl.GL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.apache.log4j.Logger;
import org.jzy3d.io.IGLLoader;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Normal;
import org.jzy3d.plot3d.primitives.vbo.drawable.DrawableVBO;

public class MatlabVBOLoader
implements IGLLoader<DrawableVBO> {
    protected String filename;
    protected static int C1 = 0;
    protected static int C2 = 1;
    protected static int C3 = 2;

    public MatlabVBOLoader(String filename) {
        this.filename = filename;
    }

    @Override
    public void load(GL gl, DrawableVBO drawable) throws Exception {
        MatFileReader mfr = new MatFileReader(this.filename);
        MLNumericArray x = (MLNumericArray)mfr.getMLArray("X");
        MLNumericArray y = (MLNumericArray)mfr.getMLArray("Y");
        MLNumericArray z = (MLNumericArray)mfr.getMLArray("Z");
        int n = x.getN();
        int components = 3;
        int geomsize = 3;
        FloatBuffer vertices = FloatBuffer.allocate(n * (components * 2) * geomsize);
        IntBuffer indices = IntBuffer.allocate(n * geomsize);
        BoundingBox3d bounds = new BoundingBox3d();
        int size = 0;
        for (int i = 0; i < n; ++i) {
            Coord3d c1 = new Coord3d(((Float)x.getReal(C1, i)).floatValue(), ((Float)y.getReal(C1, i)).floatValue(), ((Float)z.getReal(C1, i)).floatValue());
            Coord3d c2 = new Coord3d(((Float)x.getReal(C2, i)).floatValue(), ((Float)y.getReal(C2, i)).floatValue(), ((Float)z.getReal(C2, i)).floatValue());
            Coord3d c3 = new Coord3d(((Float)x.getReal(C3, i)).floatValue(), ((Float)y.getReal(C3, i)).floatValue(), ((Float)z.getReal(C3, i)).floatValue());
            Coord3d no = Normal.compute(c1, c2, c3);
            indices.put(size++);
            vertices.put(c1.x);
            vertices.put(c1.y);
            vertices.put(c1.z);
            vertices.put(no.x);
            vertices.put(no.y);
            vertices.put(no.z);
            bounds.add(c1);
            indices.put(size++);
            vertices.put(c2.x);
            vertices.put(c2.y);
            vertices.put(c2.z);
            vertices.put(no.x);
            vertices.put(no.y);
            vertices.put(no.z);
            bounds.add(c2);
            indices.put(size++);
            vertices.put(c3.x);
            vertices.put(c3.y);
            vertices.put(c3.z);
            vertices.put(no.x);
            vertices.put(no.y);
            vertices.put(no.z);
            bounds.add(c3);
        }
        vertices.rewind();
        indices.rewind();
        drawable.setData(gl, indices, vertices, bounds);
        Logger.getLogger(MatlabVBOLoader.class).info((Object)("done loading " + this.filename));
    }
}

