/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.io.ToLine;

public class SimpleCsv {
    public static <T> void write(List<T> entities, String file, char separator, ToLine<T> toLine) throws IOException {
        File parent = new File(file).getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileWriter fw = new FileWriter(file);
        CSVWriter writer = new CSVWriter((Writer)fw, separator);
        for (T entity : entities) {
            writer.writeNext(toLine.toLine(entity));
        }
        writer.close();
    }

    public static void write(List lines, String file, char separator) throws IOException {
        File parent = new File(file).getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileWriter fw = new FileWriter(file);
        CSVWriter writer = new CSVWriter((Writer)fw, separator);
        writer.writeAll(lines);
        writer.close();
    }

    public static void writeLines(List lines, String file, char separator) throws IOException {
        File parent = new File(file).getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileWriter fw = new FileWriter(file);
        CSVWriter writer = new CSVWriter((Writer)fw, separator);
        writer.writeAll(SimpleCsv.convert(lines));
        writer.close();
    }

    protected static List convert(List lines) {
        ArrayList<String[]> out = new ArrayList<String[]>(lines.size());
        for (String line : lines) {
            String[] content = new String[]{line};
            out.add(content);
        }
        return out;
    }
}

