/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart2d;

import com.jogamp.opengl.GLCapabilities;
import java.util.HashMap;
import java.util.Map;
import org.jzy3d.chart.AWTChart;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.chart2d.Chart2dComponentFactory;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot2d.primitives.Serie2d;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ElapsedTimeTickRenderer;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;

public class Chart2d
extends AWTChart {
    protected Map<String, Serie2d> series = new HashMap<String, Serie2d>();

    public void layout2d() {
        IAxeLayout axe = this.getAxeLayout();
        axe.setZAxeLabelDisplayed(false);
        axe.setTickLineDisplayed(false);
        View view = this.getView();
        view.setViewPositionMode(ViewPositionMode.TOP);
        view.setSquared(true);
        view.getCamera().setViewportMode(ViewportMode.STRETCH_TO_FILL);
    }

    public void asTimeChart(float timeMax, float ymin, float ymax, String xlabel, String ylabel) {
        IAxeLayout axe = this.getAxeLayout();
        axe.setYAxeLabel(ylabel);
        axe.setXAxeLabel(xlabel);
        axe.setXTickRenderer(new ElapsedTimeTickRenderer());
        View view = this.getView();
        view.setBoundManual(new BoundingBox3d(0.0f, timeMax, ymin, ymax, -1.0f, 1.0f));
    }

    public Serie2d getSerie(String name, Serie2d.Type type) {
        Serie2d serie = null;
        if (!this.series.keySet().contains(name)) {
            serie = this.factory.newSerie(name, type);
            this.addDrawable(serie.getDrawable());
        } else {
            serie = this.series.get(name);
        }
        return serie;
    }

    public Chart2d() {
        this(IChartComponentFactory.Toolkit.newt);
    }

    public Chart2d(IChartComponentFactory.Toolkit toolkit) {
        this((IChartComponentFactory)new Chart2dComponentFactory(), toolkit);
    }

    public Chart2d(IChartComponentFactory factory, IChartComponentFactory.Toolkit toolkit) {
        this(factory, Quality.Intermediate, toolkit);
    }

    public Chart2d(IChartComponentFactory factory, Quality quality) {
        this(factory, quality, IChartComponentFactory.Toolkit.newt);
    }

    public Chart2d(IChartComponentFactory factory, Quality quality, IChartComponentFactory.Toolkit toolkit) {
        this(factory, quality, toolkit.toString());
        this.layout2d();
    }

    public Chart2d(IChartComponentFactory factory, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
        super(factory, quality, windowingToolkit, capabilities);
    }

    public Chart2d(IChartComponentFactory factory, Quality quality, String windowingToolkit) {
        super(factory, quality, windowingToolkit);
        this.layout2d();
    }

    public Chart2d(Quality quality, String windowingToolkit) {
        super(quality, windowingToolkit);
    }

    public Chart2d(Quality quality) {
        super(quality);
    }

    public Chart2d(String windowingToolkit) {
        super(windowingToolkit);
    }
}

