/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.graphs;

import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.mouse.camera.ICameraMouseController;
import org.jzy3d.chart.controllers.mouse.picking.NewtMousePickingController;
import org.jzy3d.chart.factories.ChartComponentFactory;
import org.jzy3d.picking.IObjectPickedListener;
import org.jzy3d.picking.PickingSupport;

public class GraphChartComponentFactory
extends ChartComponentFactory {
    static Logger logger = Logger.getLogger(GraphChartComponentFactory.class);

    @Override
    public ICameraMouseController newMouseController(Chart chart) {
        ICameraMouseController mouse = null;
        if (chart.getWindowingToolkit().equals("newt")) {
            throw new IllegalArgumentException("newt not supported");
        }
        mouse = this.newAWTMouseController(chart);
        return mouse;
    }

    public ICameraMouseController newAWTMouseController(final Chart chart) {
        NewtMousePickingController mouse = new NewtMousePickingController(chart);
        mouse.getPickingSupport().addObjectPickedListener(new IObjectPickedListener(){

            @Override
            public void objectPicked(List<? extends Object> vertices, PickingSupport picking) {
                for (Object object : vertices) {
                    logger.info((Object)("picked: " + object));
                }
                chart.render();
            }
        });
        return mouse;
    }
}

