/*
 * Decompiled with CFR 0.152.
 */
package il.ac.idc.jdt;

import il.ac.idc.jdt.DelaunayTriangulation;
import il.ac.idc.jdt.Point;
import il.ac.idc.jdt.Triangle;
import il.ac.idc.jdt.UnsupportedFormatException;
import il.ac.idc.jdt.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class IOParsers {
    public static List<Point> readPoints(File file) throws IOException {
        return IOParsers.readPoints(new FileInputStream(file));
    }

    public static List<Point> readPoints(String file) throws IOException {
        return IOParsers.readPoints(new FileInputStream(file));
    }

    public static List<Point> readPoints(InputStream is) throws IOException {
        block6: {
            String s;
            BufferedReader br;
            block5: {
                List<Point> list;
                br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(is));
                    while ((s = br.readLine()).startsWith("/")) {
                    }
                    if (!s.equals("begin")) break block5;
                    list = IOParsers.readSmf(br);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(br);
                    throw throwable;
                }
                Utils.closeQuietly(br);
                return list;
            }
            if (!Utils.isNumeric(s)) break block6;
            List<Point> list = IOParsers.readTsin(br, s);
            Utils.closeQuietly(br);
            return list;
        }
        throw new UnsupportedFormatException("File format not recognized");
    }

    private static List<Point> readSmf(BufferedReader is) throws IOException {
        String s;
        while (!(s = is.readLine()).startsWith("v")) {
        }
        double dx = 1.0;
        double dy = 1.0;
        double dz = 1.0;
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        ArrayList<Point> points = new ArrayList<Point>();
        while (s != null && s.charAt(0) == 'v') {
            StringTokenizer st = new StringTokenizer(s);
            st.nextToken();
            double d1 = new Double(st.nextToken()) * dx + minX;
            double d2 = new Double(st.nextToken()) * dy + minY;
            double d3 = new Double(st.nextToken()) * dz + minZ;
            points.add(new Point(d1, d2, d3));
            s = is.readLine();
        }
        return points;
    }

    private static List<Point> readTsin(BufferedReader is, String firstLine) throws IOException {
        String s;
        ArrayList<Point> points = new ArrayList<Point>();
        while ((s = is.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(s);
            double d1 = new Double(st.nextToken());
            double d2 = new Double(st.nextToken());
            double d3 = new Double(st.nextToken());
            points.add(new Point(d1, d2, d3));
        }
        return points;
    }

    public static void exportSmf(List<Triangle> triangulation, OutputStream os) {
        IOParsers.exportSmf(triangulation, new OutputStreamWriter(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportSmf(List<Triangle> triangulation, Writer writer) {
        HashSet<Point> pointSet = new HashSet<Point>();
        for (Triangle t : triangulation) {
            if (t.isHalfplane()) continue;
            pointSet.add(t.getA());
            pointSet.add(t.getB());
            pointSet.add(t.getC());
        }
        ArrayList pointList = new ArrayList(pointSet);
        Collections.sort(pointList);
        HashMap pointMap = new HashMap();
        for (int i = 0; i < pointList.size(); ++i) {
            pointMap.put(pointList.get(i), i);
        }
        PrintWriter os = new PrintWriter(writer);
        try {
            os.println("begin");
            for (Point p : pointList) {
                os.println(String.format("v %s %s %s", p.getX(), p.getY(), p.getZ()));
            }
            for (Triangle t : triangulation) {
                if (t.isHalfplane()) continue;
                Integer i1 = (Integer)pointMap.get(t.getA());
                Integer i2 = (Integer)pointMap.get(t.getB());
                Integer i3 = (Integer)pointMap.get(t.getC());
                if (i1 == null || i2 == null || i3 == null) {
                    throw new RuntimeException("wrong triangulation inner bug - cant write as an SMF file!");
                }
                os.println(String.format("f %d %d %d", i1 + 1, i2 + 1, i3 + 1));
            }
            os.println("end");
        }
        finally {
            Utils.closeQuietly(os);
        }
    }

    public static void exportSmf(List<Triangle> triangulation, File smfFile) throws IOException {
        IOParsers.exportSmf(triangulation, new FileWriter(smfFile));
    }

    public static void exportSmf(List<Triangle> triangulation, String smfFile) throws IOException {
        IOParsers.exportSmf(triangulation, new FileWriter(smfFile));
    }

    public static void exportTsin(DelaunayTriangulation dto, File tsinFile) throws IOException {
        IOParsers.exportTsin(dto, new FileWriter(tsinFile));
    }

    public static void exportTsin(DelaunayTriangulation dto, String tsinFile) throws IOException {
        IOParsers.exportTsin(dto, new FileWriter(tsinFile));
    }

    public static void exportTsin(DelaunayTriangulation dto, OutputStream os) {
        IOParsers.exportTsin(dto, new OutputStreamWriter(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTsin(DelaunayTriangulation dto, Writer writer) {
        PrintWriter os = new PrintWriter(writer);
        try {
            int len = dto.size();
            os.println(len);
            Iterator<Point> it = dto.verticesIterator();
            while (it.hasNext()) {
                Point p = it.next();
                os.println(String.format("%s %s %s", p.getX(), p.getY(), p.getZ()));
            }
        }
        finally {
            Utils.closeQuietly(os);
        }
    }

    public static void exportCHTsin(DelaunayTriangulation dto, String tsinFile) throws IOException {
        FileWriter fw = new FileWriter(tsinFile);
        PrintWriter os = new PrintWriter(fw);
        os.println(dto.getConvexHullSize());
        Iterator<Point> it = dto.getConvexHullVerticesIterator();
        while (it.hasNext()) {
            Point p = it.next();
            os.println(String.format("%s %s", p.getX(), p.getY()));
        }
        os.close();
        fw.close();
    }
}

