/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fonts.truetype;

import org.jfree.fonts.registry.FontIdentifier;
import org.jfree.fonts.registry.FontType;

public class TrueTypeFontIdentifier
implements FontIdentifier {
    private String fileName;
    private String fontName;
    private String fontVariant;
    private int collectionIndex;
    private long offset;

    public TrueTypeFontIdentifier(String fileName, String fontName, String fontVariant, int collectionIndex, long offset) {
        if (fileName == null) {
            throw new NullPointerException();
        }
        if (fontName == null) {
            throw new NullPointerException();
        }
        if (fontVariant == null) {
            throw new NullPointerException();
        }
        this.fontVariant = fontVariant;
        this.fileName = fileName;
        this.fontName = fontName;
        this.collectionIndex = collectionIndex;
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrueTypeFontIdentifier that = (TrueTypeFontIdentifier)o;
        if (this.collectionIndex != that.collectionIndex) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        if (!this.fontName.equals(that.fontName)) {
            return false;
        }
        return this.fontVariant.equals(that.fontVariant);
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public FontType getFontType() {
        return FontType.OPENTYPE;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public long getOffset() {
        return this.offset;
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = 29 * result + this.fontName.hashCode();
        result = 29 * result + this.fontVariant.hashCode();
        result = 29 * result + this.collectionIndex;
        result = 29 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public boolean isScalable() {
        return true;
    }
}

