/*
 * Decompiled with CFR 0.152.
 */
package jhpro.engine3d;

class Vec {
    public static final Vec x_direction = new Vec(1, 0, 0);
    public static final Vec y_direction = new Vec(0, 1, 0);
    public static final Vec z_direction = new Vec(0, 0, 1);
    public double x;
    public double y;
    public double z;

    public Vec substract(Vec vec) {
        return new Vec(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public Vec() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vec crossProduct(Vec vec) {
        return new Vec(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public Vec(int a, int b, int c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec(double a, double b, double c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public Vec(Vec a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public static Vec add(Vec a, Vec b) {
        return new Vec(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public Vec add(Vec p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
        return this;
    }

    public static Vec sub(Vec a, Vec b) {
        return new Vec(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public void diff(Vec a, Vec b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public static Vec cross(Vec a, Vec b) {
        return new Vec(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static double dot(Vec a, Vec b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public Vec uvec() {
        double len = this.mag();
        if (len > 0.0) {
            return new Vec(this.x / len, this.y / len, this.z / len);
        }
        return new Vec(this);
    }

    public double normalize() {
        double d;
        double len = this.mag();
        if (d > 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
        return len;
    }

    public Vec scale(double a) {
        this.x *= a;
        this.y *= a;
        this.z *= a;
        return this;
    }

    public void negate(Vec a) {
        this.x = -a.x;
        this.y = -a.y;
        this.z = -a.z;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double mag2() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public String toString() {
        return " ( " + this.x + ", " + this.y + ", " + this.z + " ) ";
    }

    public String toStringVerbose() {
        Vec u_vec = new Vec(this);
        double len = u_vec.normalize();
        return this.toString() + len + u_vec.toString();
    }

    public static Vec addsf(double s, Vec A, Vec B) {
        return new Vec(s * A.x + B.x, s * A.y + B.y, s * A.z + B.z);
    }

    public static Vec addsb(double s, Vec A, double t, Vec B) {
        return new Vec(s * A.x + t * B.x, s * A.y + t * B.y, s * A.z + t * B.z);
    }
}

