/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import com.yahoo.egads.control.ProcessableObject;
import com.yahoo.egads.control.ProcessableObjectFactory;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.utilities.InputProcessor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;

public class StdinProcessor
implements InputProcessor {
    @Override
    public void processInput(Properties p) throws Exception {
        String s;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Integer aggr = 1;
        if (p.getProperty("AGGREGATION") != null) {
            aggr = new Integer(p.getProperty("AGGREGATION"));
        }
        while ((s = in.readLine()) != null && s.length() != 0) {
            ArrayList<TimeSeries> metrics = StdinProcessor.createTimeSeries(s, aggr);
            for (TimeSeries ts : metrics) {
                ProcessableObject po = ProcessableObjectFactory.create(ts, p);
                po.process();
            }
        }
    }

    private static ArrayList<TimeSeries> createTimeSeries(String s, Integer aggr) throws Exception {
        ArrayList<TimeSeries> output = new ArrayList<TimeSeries>();
        String[] tokens = s.split("\t");
        String meta = "meta";
        int tokenNum = 1;
        for (String t : tokens) {
            if (t.contains("{(")) {
                output.add(StdinProcessor.convertStringToTS(t, meta + "-" + Integer.toString(tokenNum)));
                ++tokenNum;
                continue;
            }
            meta = meta + "-" + t;
        }
        if (aggr > 1) {
            for (TimeSeries t : output) {
                t.data = t.aggregate(aggr);
                t.meta.name = t.meta.name + "_aggr_" + aggr;
            }
        }
        return output;
    }

    private static TimeSeries convertStringToTS(String s, String tokenNum) throws Exception {
        String[] tuples;
        TimeSeries ts = new TimeSeries();
        ts.meta.fileName = tokenNum;
        ts.meta.name = tokenNum;
        for (String tuple : tuples = s.split("\\),")) {
            tuple = tuple.replaceAll("[{}\\(\\)]", "");
            String[] vals = tuple.split(",");
            Float val = new Float(vals[1]);
            ts.append(new Long(vals[0]), val.floatValue());
        }
        return ts;
    }
}

