/*
 * Decompiled with CFR 0.152.
 */
package jport;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.UIManager;
import jehep.utils.Util;

public class EnvGlobal {
    public static final String SERVER_URL = "http://jwork.org/jhepwork/support/";
    public static String BUILD_DATE;
    public static String BUILD_BY;
    public static String VERSION;
    public static String TITLE;
    public static String OS;
    public static int BUILD_UPDATE_TIME;
    public static int isCodeView;
    public static boolean CheckFileTime;
    public static String JHPLOT_BUILD_DATE;
    public static String JHPLOT_BUILD_BY;
    public static String JHPLOT_VERSION;
    public static String JHPLOT_JAR;
    public static boolean hasToBeRestarted;
    public static String JYTHON_VERSION;
    public static String JYTHON_INI;
    private static final int SECONDS = 3000;
    private static Timer timer;
    public static Locale locale;
    public static String LANGU;
    public static String OSsys;
    public static String DirPath;
    public static final String fSep;
    public static final String lSep;
    public static String curDir;
    public static Font globalFont;
    public static String INIFILE;
    public static String INIRUN;
    public static List<String> RunComm;
    public static String RunCommText;
    public static String LookAndFeel;
    public static JLabel MessageBar;
    public static Color FontColor;
    public static Font FontBold;
    public static Font FontPlain;
    public static String INIDIR;
    public static String ClassPath;

    public static void init() {
        String OS = System.getProperty("os.name").toLowerCase();
        curDir = System.getProperty("user.dir");
        JYTHON_VERSION = "Jython 2.5.1";
        int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
        int fontSize = (int)Math.round(13.0 * (double)screenRes / 72.0);
        globalFont = new Font("Arial", 1, 16);
        DirPath = System.getProperty("jehep.home");
        ClassPath = System.getProperty("java.class.path");
        LookAndFeel = UIManager.getSystemLookAndFeelClassName();
        LANGU = "en";
        locale = new Locale(LANGU);
        Locale.setDefault(locale);
        OSsys = "linux";
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            OSsys = "windows";
        }
        if (OS.startsWith("mac os x")) {
            OSsys = "mac";
        }
        FontColor = Color.black;
        FontBold = new Font("Lucida Sans", 1, 14);
        FontPlain = new Font("Lucida Sans", 0, 14);
        EnvGlobal.readManifest();
    }

    public static void writeComm() {
        File fprop = new File(INIFILE);
        if (fprop.exists()) {
            try {
                FileOutputStream fout = new FileOutputStream(INIRUN);
                new PrintStream(fout).println(RunCommText);
                fout.close();
            }
            catch (IOException e) {
                System.err.println("Unable to write :" + INIRUN);
            }
        }
    }

    public static void readComm() {
        RunCommText = "";
        try {
            String s;
            FileReader inF = new FileReader(INIRUN);
            BufferedReader br = new BufferedReader(inF);
            while ((s = br.readLine()) != null) {
                RunCommText = RunCommText + s + lSep;
            }
            inF.close();
        }
        catch (IOException e) {
            System.err.println("Unable to read :" + INIRUN);
        }
    }

    public static String readFile(String file) {
        String tmp = "";
        try {
            String s;
            FileReader inF = new FileReader(file);
            BufferedReader br = new BufferedReader(inF);
            while ((s = br.readLine()) != null) {
                tmp = tmp + s + lSep;
            }
            inF.close();
        }
        catch (IOException e) {
            System.err.println("Unable to read :" + file);
        }
        return tmp;
    }

    public static void buildComm() {
        RunComm.clear();
        RunCommText = RunCommText.trim();
        if (RunCommText.length() > 0) {
            StringTokenizer st = new StringTokenizer(RunCommText, lSep);
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                if ((tmp = tmp.trim()).startsWith("#")) continue;
                RunComm.add(tmp.trim());
            }
        }
    }

    public static String filesList(String dir, String extension) {
        return Util.getListFiles((String)dir, (String)extension);
    }

    public static String filesListStrip(String dir, String extension) {
        String s = Util.getListFiles((String)dir, (String)extension);
        s = s.replace(dir + fSep, "");
        return s;
    }

    public static String jarDirectories(String dirName) {
        String tmp = "";
        File dir = new File(dirName);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] directories = dir.listFiles(fileFilter);
        for (int i = 0; i < directories.length; ++i) {
            String ss = directories[i].toString();
            int k1 = ss.lastIndexOf(fSep);
            String g = ss.substring(k1 + 1);
            tmp = tmp + " -C " + dirName + "  " + g;
        }
        return tmp;
    }

    public static boolean filesRemove(String dir, String extension) {
        return Util.removeListFiles((String)dir, (String)extension);
    }

    public static void readManifest() {
        String manf = DirPath + fSep + "lib" + fSep + "jehep" + fSep + "jhporto.jar";
        BUILD_DATE = "20100120";
        BUILD_BY = "S.Chekanov";
        VERSION = "2.8";
        try {
            JarFile jar = new JarFile(manf);
            Manifest manifest = jar.getManifest();
            Attributes attribs = manifest.getMainAttributes();
            BUILD_DATE = attribs.getValue("Built-Date");
            BUILD_BY = attribs.getValue("Built-By");
            VERSION = attribs.getValue("Version");
        }
        catch (IOException e) {
            System.out.println("Cannot read jar-file manifest: " + manf);
        }
    }

    public static String substitudePorto(String s) {
        String tmp = s;
        if (s.indexOf("HPlot3D") > 0) {
            tmp = s.replace("HPlot3D", "jport.HPort3D.get");
            tmp = "import jport; " + tmp;
            return tmp;
        }
        if (s.indexOf("HPlot") > 0) {
            tmp = s.replace("HPlot", "jport.HPort.get");
            tmp = "import jport; " + tmp;
            return tmp;
        }
        return tmp;
    }

    static {
        BUILD_UPDATE_TIME = 45000;
        isCodeView = -1;
        CheckFileTime = true;
        JHPLOT_JAR = "jhplot.jar";
        fSep = System.getProperty("file.separator");
        lSep = System.getProperty("line.separator");
        INIFILE = "";
        INIRUN = "";
    }
}

