/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExecutableChannels {
    private static final Logger logger = Logger.getLogger(ExecutableChannels.class);
    protected static final int DEFAULT_PORT = 7114;
    protected static final String DEFAULT_MFILE = "examples/machines.test";
    protected final ChannelFactory cf = new ChannelFactory();
    protected SocketChannel[] channels = null;
    protected String[] servers = null;
    protected int[] ports = null;

    protected ExecutableChannels() {
        this.cf.init();
    }

    public ExecutableChannels(String[] srvs) {
        this();
        if (srvs == null) {
            return;
        }
        this.servers = new String[srvs.length];
        this.ports = new int[srvs.length];
        for (int i = 0; i < srvs.length; ++i) {
            this.setServerPort(i, srvs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableChannels(String mfile) throws FileNotFoundException {
        this();
        if (mfile == null || mfile.length() == 0) {
            mfile = DEFAULT_MFILE;
        }
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(mfile), Charset.forName("UTF8"));
        BufferedReader in = new BufferedReader(isr);
        String line = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (in.ready()) {
                line = in.readLine();
                if (line == null) {
                    break;
                }
                int x = line.indexOf("#");
                if (x >= 0) {
                    line = line.substring(0, x);
                }
                if ((line = line.trim()).length() == 0) continue;
                list.add(line);
            }
        }
        catch (IOException ignored) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        logger.debug((Object)("list.size() in " + mfile + " = " + list.size()));
        if (list.size() == 0) {
            return;
        }
        this.servers = new String[list.size()];
        this.ports = new int[list.size()];
        for (int i = 0; i < this.servers.length; ++i) {
            this.setServerPort(i, (String)list.get(i));
        }
    }

    protected void setServerPort(int i, String srv) {
        int x = srv.indexOf(":");
        this.ports[i] = 7114;
        if (x < 0) {
            this.servers[i] = srv;
        } else {
            this.servers[i] = srv.substring(0, x);
            String p = srv.substring(x + 1, srv.length());
            try {
                this.ports[i] = Integer.parseInt(p);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer("ExecutableChannels(");
        if (this.servers != null) {
            for (i = 0; i < this.servers.length; ++i) {
                s.append(this.servers[i] + ":" + this.ports[i]);
                if (i >= this.servers.length - 1) continue;
                s.append(" ");
            }
        }
        if (this.channels != null) {
            s.append(" channels = ");
            for (i = 0; i < this.channels.length; ++i) {
                s.append(this.channels[i]);
                if (i >= this.channels.length - 1) continue;
                s.append(" ");
            }
        }
        s.append(")");
        return s.toString();
    }

    public int numServers() {
        if (this.servers != null) {
            return this.servers.length;
        }
        return -1;
    }

    public String getMasterHost() {
        if (this.servers != null && this.servers.length > 0) {
            return this.servers[0];
        }
        return null;
    }

    public int getMasterPort() {
        if (this.ports != null && this.ports.length > 0) {
            return this.ports[0];
        }
        return 0;
    }

    public int numChannels() {
        if (this.channels != null) {
            return this.channels.length;
        }
        return -1;
    }

    public void open() throws IOException {
        logger.debug((Object)("opening " + this.servers.length + " channels"));
        if (this.servers.length <= 1) {
            throw new IOException("to few servers");
        }
        this.channels = new SocketChannel[this.servers.length - 1];
        for (int i = 1; i < this.servers.length; ++i) {
            this.channels[i - 1] = this.cf.getChannel(this.servers[i], this.ports[i]);
        }
    }

    public void open(int nc) throws IOException {
        logger.debug((Object)("opening " + nc + " channels"));
        if (this.servers.length <= 1) {
            throw new IOException("to few servers");
        }
        this.channels = new SocketChannel[nc];
        int j = 1;
        for (int i = 0; i < this.channels.length; ++i) {
            if (j >= this.servers.length) {
                j = 1;
            }
            this.channels[i] = this.cf.getChannel(this.servers[j], this.ports[j]);
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        logger.debug((Object)"closing ExecutableChannels");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.channels != null) {
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] == null) continue;
                try {
                    this.channels[i].send("Stop");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.channels[i].close();
                }
                this.channels[i] = null;
            }
            this.channels = null;
        }
        logger.debug((Object)"ExecuteChannels closed");
    }

    public SocketChannel getChannel(int i) {
        if (this.channels != null && 0 <= i && i < this.channels.length) {
            return this.channels[i];
        }
        return null;
    }

    SocketChannel[] getChannels() {
        return this.channels;
    }

    public void send(int i, Object o) throws IOException {
        if (this.channels != null && 0 <= i && i < this.channels.length) {
            this.channels[i].send(o);
        }
    }

    public Object receive(int i) throws IOException, ClassNotFoundException {
        if (this.channels != null && 0 <= i && i < this.channels.length) {
            return this.channels[i].receive();
        }
        return null;
    }
}

