/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.BackSubstKronecker;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SubstKronecker;
import edu.jas.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PolyUfdUtil {
    private static final Logger logger = Logger.getLogger(PolyUfdUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> integralFromQuotientCoefficients(GenPolynomialRing<GenPolynomial<C>> fac, GenPolynomial<Quotient<C>> A) {
        Element B = ((GenPolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        GenPolynomial<Object> c = null;
        GreatestCommonDivisorSubres ufd = new GreatestCommonDivisorSubres();
        int s = 0;
        for (Quotient<C> quotient : A.getMap().values()) {
            GenPolynomial x = quotient.den;
            if (c == null) {
                c = x;
                s = x.signum();
                continue;
            }
            GenPolynomial d = ufd.gcd(c, x);
            c = c.multiply((Object)x.divide(d));
        }
        if (s < 0) {
            c = c.negate();
        }
        for (Map.Entry entry : A.getMap().entrySet()) {
            ExpVector e = (ExpVector)entry.getKey();
            Quotient a = (Quotient)entry.getValue();
            GenPolynomial<Object> b = c.divide(a.den);
            GenPolynomial<GenPolynomial<Object>> p = a.num.multiply(b);
            ((GenPolynomial)B).doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<GenPolynomial<C>>> integralFromQuotientCoefficients(GenPolynomialRing<GenPolynomial<C>> fac, Collection<GenPolynomial<Quotient<C>>> L) {
        if (L == null) {
            return null;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> list = new ArrayList<GenPolynomial<GenPolynomial<C>>>(L.size());
        for (GenPolynomial<Quotient<C>> p : L) {
            list.add(PolyUfdUtil.integralFromQuotientCoefficients(fac, p));
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Quotient<C>> quotientFromIntegralCoefficients(GenPolynomialRing<Quotient<C>> fac, GenPolynomial<GenPolynomial<C>> A) {
        Element B = ((GenPolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        RingFactory cfac = fac.coFac;
        QuotientRing qfac = (QuotientRing)cfac;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> a = y.getValue();
            Quotient<C> p = new Quotient<C>(qfac, a);
            if (p.isZERO()) continue;
            ((GenPolynomial)B).doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Quotient<C>>> quotientFromIntegralCoefficients(GenPolynomialRing<Quotient<C>> fac, Collection<GenPolynomial<GenPolynomial<C>>> L) {
        if (L == null) {
            return null;
        }
        ArrayList<GenPolynomial<Quotient<C>>> list = new ArrayList<GenPolynomial<Quotient<C>>>(L.size());
        for (GenPolynomial<GenPolynomial<C>> p : L) {
            list.add(PolyUfdUtil.quotientFromIntegralCoefficients(fac, p));
        }
        return list;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> fromIntegerCoefficients(GenPolynomialRing<GenPolynomial<C>> fac, GenPolynomial<GenPolynomial<BigInteger>> A) {
        Element B = ((GenPolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        RingFactory cfac = fac.coFac;
        GenPolynomialRing rfac = (GenPolynomialRing)cfac;
        for (Map.Entry<ExpVector, GenPolynomial<BigInteger>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<BigInteger> a = y.getValue();
            GenPolynomial p = PolyUtil.fromIntegerCoefficients(rfac, a);
            if (p.isZERO()) continue;
            ((GenPolynomial)B).doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> fromIntegerCoefficients(GenPolynomialRing<GenPolynomial<C>> fac, List<GenPolynomial<GenPolynomial<BigInteger>>> L) {
        ArrayList<GenPolynomial<GenPolynomial<C>>> K = null;
        if (L == null) {
            return K;
        }
        K = new ArrayList<GenPolynomial<GenPolynomial<C>>>(L.size());
        if (L.size() == 0) {
            return K;
        }
        for (GenPolynomial<GenPolynomial<BigInteger>> a : L) {
            GenPolynomial<GenPolynomial<C>> b = PolyUfdUtil.fromIntegerCoefficients(fac, a);
            K.add(b);
        }
        return K;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> introduceLowerVariable(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<C> A) {
        if (A == null || rfac == null) {
            return null;
        }
        GenPolynomial<GenPolynomial<C>> Pc = ((GenPolynomial)rfac.getONE()).multiply(A);
        if (Pc.isZERO()) {
            return Pc;
        }
        Pc = PolyUtil.switchVariables(Pc);
        return Pc;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> substituteFromAlgebraicCoefficients(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<AlgebraicNumber<C>> A, long k) {
        if (A == null || rfac == null) {
            return null;
        }
        if (A.isZERO()) {
            return rfac.getZERO();
        }
        GenPolynomialRing apfac = A.ring;
        GenPolynomial x = apfac.univariate(0);
        AlgebraicNumberRing afac = (AlgebraicNumberRing)A.ring.coFac;
        AlgebraicNumber alpha = afac.getGenerator();
        Element ka = afac.fromInteger(k);
        GenPolynomial s = x.subtract(((AlgebraicNumber)ka).multiply(alpha));
        if (debug) {
            logger.info((Object)("x - k alpha: " + s));
        }
        GenPolynomial B = PolyUtil.substituteMain(A, s);
        GenPolynomial<GenPolynomial<C>> Pc = PolyUtil.fromAlgebraicCoefficients(rfac, B);
        Pc = PolyUtil.switchVariables(Pc);
        return Pc;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> substituteConvertToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<C> A, long k) {
        if (A == null || pfac == null) {
            return null;
        }
        if (A.isZERO()) {
            return pfac.getZERO();
        }
        GenPolynomial<AlgebraicNumber<C>> B = PolyUtil.convertToAlgebraicCoefficients(pfac, A);
        GenPolynomial x = pfac.univariate(0);
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        AlgebraicNumber alpha = afac.getGenerator();
        Element ka = afac.fromInteger(k);
        GenPolynomial s = x.sum(((AlgebraicNumber)ka).multiply(alpha));
        GenPolynomial<AlgebraicNumber<C>> N = PolyUtil.substituteMain(B, s);
        return N;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> norm(GenPolynomial<AlgebraicNumber<C>> A, long k) {
        if (A == null) {
            return null;
        }
        GenPolynomialRing pfac = A.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        GenPolynomial agen = afac.modul;
        GenPolynomialRing cfac = afac.ring;
        if (A.isZERO()) {
            return cfac.getZERO();
        }
        AlgebraicNumber<C> ldcf = A.leadingBaseCoefficient();
        if (!ldcf.isONE()) {
            A = A.monic();
        }
        GenPolynomialRing<GenPolynomial<C>> rfac = new GenPolynomialRing<GenPolynomial<C>>(cfac, pfac);
        GenPolynomial<GenPolynomial<C>> Ac = PolyUfdUtil.introduceLowerVariable(rfac, agen);
        GenPolynomial<GenPolynomial<C>> Pc = PolyUfdUtil.substituteFromAlgebraicCoefficients(rfac, A, k);
        Pc = PolyUtil.monic(Pc);
        GreatestCommonDivisorSubres<C> engine = new GreatestCommonDivisorSubres<C>();
        GenPolynomial Rc = engine.recursiveUnivariateResultant(Pc, Ac);
        GenPolynomial res = Rc.leadingBaseCoefficient();
        res = res.monic();
        return res;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> norm(GenPolynomial<AlgebraicNumber<C>> A) {
        return PolyUfdUtil.norm(A, 0L);
    }

    public static <C extends GcdRingElem<C>> void ensureFieldProperty(AlgebraicNumberRing<C> afac) {
        if (afac.getField() != -1) {
            return;
        }
        if (!afac.ring.coFac.isField()) {
            afac.setField(false);
            return;
        }
        FactorAbstract mf = FactorFactory.getImplementation(afac.ring);
        if (mf.isIrreducible(afac.modul)) {
            afac.setField(true);
        } else {
            afac.setField(false);
        }
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> substituteKronecker(GenPolynomial<C> A) {
        if (A == null) {
            return A;
        }
        long d = A.degree() + 1L;
        return PolyUfdUtil.substituteKronecker(A, d);
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> substituteKronecker(GenPolynomial<C> A, long d) {
        if (A == null) {
            return A;
        }
        RingFactory cfac = A.ring.coFac;
        GenPolynomialRing ufac = new GenPolynomialRing(cfac, 1);
        Element B = ((GenPolynomial)ufac.getZERO()).copy();
        if (A.isZERO()) {
            return B;
        }
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            long f = 0L;
            long h = 1L;
            for (int i = 0; i < e.length(); ++i) {
                long j = e.getVal(i) * h;
                f += j;
                h *= d;
            }
            ExpVector g = ExpVector.create(1, 0, f);
            ((GenPolynomial)B).doPutToMap(g, a);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> substituteKronecker(List<GenPolynomial<C>> A, int d) {
        if (A == null || A.get(0) == null) {
            return null;
        }
        return ListUtil.map(A, new SubstKronecker(d));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> backSubstituteKronecker(GenPolynomialRing<C> fac, GenPolynomial<C> A, long d) {
        if (A == null) {
            return A;
        }
        if (fac == null) {
            throw new IllegalArgumentException("null factory not allowed ");
        }
        int n = fac.nvar;
        Element B = ((GenPolynomial)fac.getZERO()).copy();
        if (A.isZERO()) {
            return B;
        }
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            long f = e.getVal(0);
            ExpVector g = ExpVector.create(n);
            for (int i = 0; i < n; ++i) {
                long j = f % d;
                f /= d;
                g = g.subst(i, j);
            }
            ((GenPolynomial)B).doPutToMap(g, a);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> backSubstituteKronecker(GenPolynomialRing<C> fac, List<GenPolynomial<C>> A, long d) {
        return ListUtil.map(A, new BackSubstKronecker<C>(fac, d));
    }
}

