/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.structure.UnaryFunctor;
import java.math.BigInteger;

class RatToIntFactor
implements UnaryFunctor<BigRational, edu.jas.arith.BigInteger> {
    final BigInteger lcm;
    final BigInteger gcd;

    public RatToIntFactor(BigInteger gcd, BigInteger lcm) {
        this.gcd = gcd;
        this.lcm = lcm;
    }

    @Override
    public edu.jas.arith.BigInteger eval(BigRational c) {
        if (c == null) {
            return new edu.jas.arith.BigInteger();
        }
        if (this.gcd.equals(BigInteger.ONE)) {
            BigInteger b = this.lcm.divide(c.denominator());
            return new edu.jas.arith.BigInteger(c.numerator().multiply(b));
        }
        BigInteger a = c.numerator().divide(this.gcd);
        BigInteger b = this.lcm.divide(c.denominator());
        return new edu.jas.arith.BigInteger(a.multiply(b));
    }
}

