/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.kern;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Logger;

public class ComputerThreads {
    private static final Logger logger = Logger.getLogger(ComputerThreads.class);
    public static boolean NO_THREADS = false;
    public static final int N_CPUS = Runtime.getRuntime().availableProcessors();
    public static final int N_THREADS = N_CPUS < 3 ? 3 : N_CPUS + N_CPUS / 2;
    static ExecutorService pool = null;

    private ComputerThreads() {
    }

    public static synchronized boolean isRunning() {
        if (pool == null) {
            return false;
        }
        return !pool.isTerminated() && !pool.isShutdown();
    }

    public static synchronized ExecutorService getPool() {
        if (pool == null) {
            pool = Executors.newCachedThreadPool();
        }
        return pool;
    }

    public static synchronized void terminate() {
        if (pool == null) {
            return;
        }
        if (pool instanceof ThreadPoolExecutor) {
            List<Runnable> r;
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)pool;
            logger.info((Object)("number of CPUs            " + N_CPUS));
            logger.info((Object)("core number of threads    " + N_THREADS));
            logger.info((Object)("current number of threads " + tpe.getPoolSize()));
            logger.info((Object)("maximal number of threads " + tpe.getLargestPoolSize()));
            BlockingQueue<Runnable> workpile = tpe.getQueue();
            if (workpile != null) {
                logger.info((Object)("queued tasks              " + workpile.size()));
            }
            if ((r = tpe.shutdownNow()).size() != 0) {
                logger.info((Object)("unfinished tasks          " + r.size()));
            }
            logger.info((Object)("number of sheduled tasks  " + tpe.getTaskCount()));
            logger.info((Object)("number of completed tasks " + tpe.getCompletedTaskCount()));
        }
        pool = null;
    }

    public static synchronized void setNoThreads() {
        NO_THREADS = true;
    }

    public static synchronized void setThreads() {
        NO_THREADS = false;
    }
}

