/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.Pair;
import edu.jas.gbufd.OrderedRPairlist;
import edu.jas.gbufd.RGroebnerBaseSeq;
import edu.jas.gbufd.RPseudoReduction;
import edu.jas.gbufd.RPseudoReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RegularRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RGroebnerBasePseudoSeq<C extends RegularRingElem<C>>
extends RGroebnerBaseSeq<C> {
    private static final Logger logger = Logger.getLogger(RGroebnerBasePseudoSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final RPseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public RGroebnerBasePseudoSeq(RingFactory<C> rf) {
        this(new RPseudoReductionSeq(), rf);
    }

    public RGroebnerBasePseudoSeq(RPseudoReduction<C> red, RingFactory<C> rf) {
        super(red);
        this.red = red;
        this.cofac = rf;
        this.engine = GCDFactory.getImplementation(rf);
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        if (F == null) {
            return F;
        }
        List<GenPolynomial<C>> bcF = this.red.reducedBooleanClosure(F);
        logger.info((Object)("#bcF-#F = " + (bcF.size() - F.size())));
        F = bcF;
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        OrderedRPairlist<GenPolynomial<C>> pairlist = null;
        for (GenPolynomial<C> genPolynomial : F) {
            if (genPolynomial.isZERO()) continue;
            GenPolynomial<C> genPolynomial2 = this.engine.basePrimitivePart(genPolynomial);
            AbelianGroupElem abelianGroupElem = genPolynomial2.abs();
            if (((GenPolynomial)abelianGroupElem).isConstant() && ((RegularRingElem)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient()).isFull()) {
                G.clear();
                G.add((GenPolynomial<C>)abelianGroupElem);
                return G;
            }
            G.add((GenPolynomial<C>)abelianGroupElem);
            if (pairlist == null) {
                pairlist = new OrderedRPairlist<GenPolynomial<C>>(modv, ((GenPolynomial)abelianGroupElem).ring);
            }
            pairlist.put((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
        }
        if (G.size() <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> H;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial = pair.pi;
            GenPolynomial pj = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.info((Object)("pi    = " + genPolynomial));
                logger.info((Object)("pj    = " + pj));
            }
            if (!this.red.moduleCriterion(modv, genPolynomial, pj)) continue;
            GenPolynomial S = this.red.SPolynomial(genPolynomial, pj);
            if (S.isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            if (((GenPolynomial)(H = this.red.normalform(G, S))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(H) = " + ((GenPolynomial)H).leadingExpVector()));
            }
            H = this.engine.basePrimitivePart((GenPolynomial<C>)H);
            if (((GenPolynomial)(H = ((GenPolynomial)H).abs())).isConstant() && ((RegularRingElem)((GenPolynomial)H).leadingBaseCoefficient()).isFull()) {
                G.clear();
                G.add((GenPolynomial<C>)H);
                return G;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            if (((GenPolynomial)H).isZERO()) continue;
            List<GenPolynomial<GenPolynomial<C>>> bcH = this.red.reducedBooleanClosure((List<GenPolynomial<GenPolynomial<C>>>)G, (GenPolynomial<GenPolynomial<C>>)H);
            for (AbelianGroupElem<GenPolynomial<C>> h : bcH) {
                h = this.engine.basePrimitivePart((GenPolynomial<GenPolynomial<C>>)h);
                h = h.abs();
                logger.info((Object)("bc(Sred) = " + h));
                G.add((GenPolynomial<C>)h);
                pairlist.put((GenPolynomial<GenPolynomial<C>>)h);
            }
            if (!this.debug || pair.getUseCriterion3() && pair.getUseCriterion4()) continue;
            logger.info((Object)("H != 0 but: " + pair));
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Gp) {
        GenPolynomial b;
        GenPolynomial<GenPolynomial> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<GenPolynomial<C>> G = new ArrayList(Gp.size());
        for (AbelianGroupElem<GenPolynomial<C>> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            a2 = a2.abs();
            G.add((GenPolynomial<C>)a2);
        }
        logger.info((Object)("minGB start with " + G.size()));
        ArrayList<GenPolynomial<Object>> F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial)G.remove(0);
            b = a;
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F, a)) {
                ArrayList ff = new ArrayList(G);
                ff.addAll(F);
                a = this.red.normalform(ff, a);
                if (a.isZERO()) {
                    if (!this.debug) continue;
                    logger.debug((Object)("minGB dropped " + b));
                    continue;
                }
                logger.info((Object)("minGB not zero " + a));
                F.add((GenPolynomial<Object>)a);
                continue;
            }
            F.add(a);
        }
        G = F;
        Collections.reverse(G);
        int len = G.size();
        int el = 0;
        while (el < len) {
            ++el;
            a = (GenPolynomial)G.remove(0);
            b = a;
            a = this.red.normalform(G, a);
            a = this.engine.basePrimitivePart(a);
            if (this.red.isBooleanClosed(a = a.abs())) {
                if (this.debug) {
                    logger.debug((Object)("minGB reduced " + b + " to " + a));
                }
                G.add(a);
                continue;
            }
            logger.info((Object)("minGB not boolean closed " + a));
            G.add(b);
        }
        F = new ArrayList(G.size());
        ArrayList ff = new ArrayList(G);
        for (int i = 0; i < ff.size(); ++i) {
            a = (GenPolynomial<GenPolynomial>)ff.get(i);
            if (a == null || a.isZERO()) continue;
            ExpVector e = a.leadingExpVector();
            for (int j = i + 1; j < ff.size(); ++j) {
                ExpVector f;
                b = (GenPolynomial)ff.get(j);
                if (b == null || b.isZERO() || !e.equals(f = b.leadingExpVector())) continue;
                a = a.sum(b);
                ff.set(j, null);
            }
            F.add((GenPolynomial<Object>)a);
        }
        G = F;
        logger.info((Object)("minGB end with #G = " + G.size()));
        return G;
    }

    List<GenPolynomial<C>> minimalGBtesting(List<GenPolynomial<C>> Gp) {
        List bcH;
        GenPolynomial b;
        AbelianGroupElem<GenPolynomial<GenPolynomial>> a;
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList G = new ArrayList(Gp.size());
        for (GenPolynomial<C> a2 : Gp) {
            if (a2 == null || a2.isZERO()) continue;
            G.add(a2);
        }
        ArrayList<GenPolynomial<Object>> F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = (GenPolynomial)G.remove(0);
            b = a;
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F, a)) {
                if (!logger.isInfoEnabled()) continue;
                ArrayList ff = new ArrayList(G);
                ff.addAll(F);
                a = this.red.normalform(ff, a);
                if (!((GenPolynomial)a).isZERO()) {
                    System.out.println("minGB nf(a) != 0 " + a);
                    bcH = this.red.reducedBooleanClosure(G, a);
                    if (bcH.size() > 1) {
                        System.out.println("minGB not bc: bcH size = " + bcH.size());
                        F.add(b);
                        continue;
                    }
                    F.add(b);
                    continue;
                }
                if (!this.isGB(ff)) {
                    System.out.println("minGB not dropped " + b);
                    F.add(b);
                    continue;
                }
                System.out.println("minGB dropped " + b);
                continue;
            }
            F.add((GenPolynomial<Object>)a);
        }
        G = F;
        Collections.reverse(G);
        int len = G.size();
        int el = 0;
        while (el < len) {
            ++el;
            a = (GenPolynomial)G.remove(0);
            b = a;
            a = this.red.normalform(G, a);
            if (this.red.isBooleanClosed(a = this.engine.basePrimitivePart((GenPolynomial<C>)a))) {
                ArrayList ff = new ArrayList(G);
                ff.add(a);
                if (this.isGB(ff)) {
                    System.out.println("minGB reduced " + b + " to " + a);
                    G.add(a);
                    continue;
                }
                System.out.println("minGB not reduced " + b + " to " + a);
                G.add(b);
                continue;
            }
            System.out.println("minGB not bc: a = " + a + "\n BC(a) = " + this.red.booleanClosure(a) + ", BR(a) = " + this.red.booleanRemainder(a));
            bcH = this.red.reducedBooleanClosure(G, a);
            if (bcH.size() > 1) {
                System.out.println("minGB not bc: bcH size = " + bcH.size());
                G.add(b);
                continue;
            }
            G.add(b);
            for (GenPolynomial genPolynomial : bcH) {
                GenPolynomial<C> genPolynomial2 = this.engine.basePrimitivePart(genPolynomial);
                AbelianGroupElem abelianGroupElem = genPolynomial2.abs();
            }
        }
        F = new ArrayList(G.size());
        for (GenPolynomial genPolynomial : G) {
            a = genPolynomial.abs();
            F.add((GenPolynomial<Object>)a);
        }
        G = F;
        F = new ArrayList(G.size());
        for (int i = 0; i < G.size(); ++i) {
            a = (GenPolynomial)G.get(i);
            if (a == null || ((GenPolynomial)a).isZERO()) continue;
            ExpVector e = ((GenPolynomial)a).leadingExpVector();
            for (int j = i + 1; j < G.size(); ++j) {
                ExpVector expVector;
                b = (GenPolynomial)G.get(j);
                if (b == null || b.isZERO() || !e.equals(expVector = b.leadingExpVector())) continue;
                a = ((GenPolynomial)a).sum(b);
                G.set(j, null);
            }
            F.add((GenPolynomial<Object>)a);
        }
        G = F;
        TreeMap<RegularRingElem, ArrayList<GenPolynomial>> bd = new TreeMap<RegularRingElem, ArrayList<GenPolynomial>>();
        for (GenPolynomial genPolynomial : G) {
            RegularRingElem cf = (RegularRingElem)genPolynomial.leadingBaseCoefficient();
            ArrayList<GenPolynomial> block = (ArrayList<GenPolynomial>)bd.get(cf = cf.idempotent());
            if (block == null) {
                block = new ArrayList<GenPolynomial>();
            }
            block.add(genPolynomial);
            bd.put(cf, block);
        }
        System.out.println("\nminGB bd:");
        for (Map.Entry entry : bd.entrySet()) {
            System.out.println("\nkey = " + entry.getKey() + ":");
            System.out.println("val = " + entry.getValue());
        }
        System.out.println();
        return G;
    }
}

