/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class PseudoReducer<C extends GcdRingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private final PairList<C> pairlist;
    private final Terminator fin;
    private final PseudoReductionPar<C> red;
    private final GreatestCommonDivisorAbstract<C> engine;
    private static final Logger logger = Logger.getLogger(PseudoReducer.class);

    PseudoReducer(Terminator fin, List<GenPolynomial<C>> G, PairList<C> L, GreatestCommonDivisorAbstract<C> engine) {
        this.fin = fin;
        this.G = G;
        this.pairlist = L;
        this.red = new PseudoReductionPar();
        this.engine = engine;
        fin.initIdle(1);
    }

    public String toString() {
        return "PseudoReducer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int reduction = 0;
        int sleeps = 0;
        while (this.pairlist.hasNext() || this.fin.hasJobs()) {
            List<GenPolynomial<C>> list;
            GenPolynomial S;
            while (!this.pairlist.hasNext()) {
                try {
                    if (++sleeps % 10 == 0) {
                        logger.info((Object)" reducer is sleeping");
                    } else {
                        logger.debug((Object)"r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.fin.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.fin.hasJobs()) break;
            this.fin.notIdle();
            Pair<C> pair = this.pairlist.removeNext();
            if (Thread.currentThread().isInterrupted()) {
                this.fin.initIdle(1);
                throw new RuntimeException("interrupt after removeNext");
            }
            if (pair == null) {
                this.fin.initIdle(1);
                continue;
            }
            GenPolynomial pi = pair.pi;
            GenPolynomial pj = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            AbelianGroupElem<GenPolynomial<C>> H = this.red.normalform(this.G, S);
            ++reduction;
            if (((GenPolynomial)H).isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("ht(H) = " + ((GenPolynomial)H).leadingExpVector()));
            }
            H = this.engine.basePrimitivePart((GenPolynomial<C>)H);
            if (((GenPolynomial)(H = ((GenPolynomial)H).abs())).isONE()) {
                this.pairlist.put((GenPolynomial<GenPolynomial<C>>)H);
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add((GenPolynomial<C>)H);
                }
                this.fin.allIdle();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + H));
            }
            list = this.G;
            synchronized (list) {
                this.G.add((GenPolynomial<C>)H);
            }
            this.pairlist.put((GenPolynomial<GenPolynomial<C>>)H);
            this.fin.initIdle(1);
        }
        this.fin.allIdle();
        logger.info((Object)("terminated, done " + reduction + " reductions"));
    }
}

