/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.PairList;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBaseFGLM<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseFGLM.class);
    private GroebnerBaseAbstract<C> sgb;

    public GroebnerBaseFGLM() {
        this.sgb = null;
    }

    public GroebnerBaseFGLM(Reduction<C> red) {
        super(red);
        this.sgb = null;
    }

    public GroebnerBaseFGLM(Reduction<C> red, PairList<C> pl) {
        super(red, pl);
        this.sgb = null;
    }

    public GroebnerBaseFGLM(Reduction<C> red, PairList<C> pl, GroebnerBaseAbstract<C> gb) {
        super(red, pl);
        this.sgb = gb;
    }

    public GroebnerBaseFGLM(GroebnerBaseAbstract<C> gb) {
        this.sgb = gb;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        if (modv != 0) {
            throw new UnsupportedOperationException("case modv != 0 not yet implemented");
        }
        if (F == null || F.size() == 0) {
            return F;
        }
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        if (F.size() <= 1) {
            GenPolynomial<C> p = F.get(0).monic();
            G.add(p);
            return G;
        }
        ArrayList Fp = new ArrayList(F.size());
        GenPolynomialRing pfac = F.get((int)0).ring;
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field: " + pfac.coFac);
        }
        TermOrder tord = new TermOrder(4);
        GenPolynomialRing<C> gfac = new GenPolynomialRing<C>(pfac.coFac, pfac.nvar, tord, pfac.getVars());
        for (GenPolynomial<C> p : F) {
            GenPolynomial g = gfac.copy(p);
            Fp.add(g);
        }
        if (this.sgb == null) {
            this.sgb = GBFactory.getImplementation(pfac.coFac);
        }
        List Gp = this.sgb.GB(modv, Fp);
        logger.info((Object)("graded GB = " + Gp));
        if (tord.equals(pfac.tord)) {
            return Gp;
        }
        if (Gp.size() == 0) {
            return Gp;
        }
        if (Gp.size() == 1) {
            GenPolynomial<C> p;
            p = pfac.copy(Gp.get(0));
            G.add(p);
            return G;
        }
        G = this.convGroebnerToLex(Gp);
        return G;
    }

    public List<GenPolynomial<C>> convGroebnerToLex(List<GenPolynomial<C>> groebnerBasis) {
        if (groebnerBasis == null || groebnerBasis.size() == 0) {
            throw new IllegalArgumentException("G may not be null or empty");
        }
        int z = this.commonZeroTest(groebnerBasis);
        if (z != 0) {
            throw new IllegalArgumentException("ideal(G) not zero dimensional, dim =  " + z);
        }
        GenPolynomialRing ring = groebnerBasis.get((int)0).ring;
        int numberOfVariables = ring.nvar;
        String[] ArrayOfVariables = ring.getVars();
        RingFactory cfac = ring.coFac;
        TermOrder invlex = new TermOrder(2);
        GenPolynomialRing<GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>> ufac = new GenPolynomialRing<GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>>(cfac, numberOfVariables, invlex, ArrayOfVariables);
        ArrayList<GenPolynomial<C>> newGB = new ArrayList<GenPolynomial<C>>();
        ArrayList<GenPolynomial<C>> H = new ArrayList<GenPolynomial<C>>();
        ArrayList redTerms = new ArrayList();
        GenPolynomial t = ring.ONE;
        redTerms.add(t);
        int indeterminates = 1;
        GenPolynomialRing cpfac = this.createRingOfIndeterminates(ring, indeterminates);
        GenPolynomialRing rfac = new GenPolynomialRing(cpfac, ring);
        GenPolynomial<GenPolynomial<Object>> q = ((GenPolynomial)rfac.getZERO()).sum(cpfac.univariate(0));
        z = -1;
        t = this.lMinterm(H, t);
        while (t != null) {
            GenPolynomial<C> h = this.red.normalform(groebnerBasis, t);
            GenPolynomial hh = PolyUtil.toRecursive(rfac, h);
            GenPolynomial p = hh.sum(q);
            List Cf = new ArrayList(p.getMap().values());
            z = this.commonZeroTest(Cf = this.red.irreducibleSet(Cf));
            if (z != 0) {
                ++indeterminates;
                redTerms.add(t);
                cpfac = this.addIndeterminate(cpfac);
                rfac = new GenPolynomialRing(cpfac, ring);
                hh = PolyUtil.toRecursive(rfac, h);
                GenPolynomial Yt = ((GenPolynomial)rfac.getZERO()).sum(cpfac.univariate(0));
                GenPolynomial Yth = hh.multiply(Yt);
                q = PolyUtil.extendCoefficients(rfac, q, 0, 0L);
                q = Yth.sum(q);
            } else {
                GenPolynomial g = ufac.getZERO();
                for (GenPolynomial pc : Cf) {
                    int[] v;
                    ExpVector e = pc.leadingExpVector();
                    if (e == null || (v = e.dependencyOnVariables()) == null || v.length == 0) continue;
                    int vi = v[0];
                    vi = indeterminates - vi;
                    GcdRingElem tc = (GcdRingElem)pc.trailingBaseCoefficient();
                    if (tc.isZERO()) continue;
                    tc = (GcdRingElem)tc.negate();
                    GenPolynomial<GcdRingElem> csRedterm = ((GenPolynomial)redTerms.get(vi - 1)).multiply(tc);
                    g = g.sum((GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>)csRedterm);
                }
                g = g.sum((GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>>)t);
                g = ufac.copy(g);
                H.add(t);
                if (!g.isZERO()) {
                    newGB.add(g);
                    logger.info((Object)("new element for GB = " + g.leadingExpVector()));
                }
            }
            t = this.lMinterm(H, t);
        }
        return newGB;
    }

    public GenPolynomial<C> lMinterm(List<GenPolynomial<C>> G, GenPolynomial<C> t) {
        GenPolynomialRing ring = t.ring;
        int numberOfVariables = ring.nvar;
        GenPolynomial<Object> u = new GenPolynomial(ring, t.leadingBaseCoefficient(), t.leadingExpVector());
        ReductionSeq<Object> redHelp = new ReductionSeq<Object>();
        for (int i = numberOfVariables - 1; i >= 0; --i) {
            GenPolynomial x = ring.univariate(i);
            if (!redHelp.isTopReducible(G, u = u.multiply((Object)x))) {
                return u;
            }
            GenPolynomial s = ring.univariate(i, u.degree(numberOfVariables - (i + 1)));
            u = u.divide(s);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<C>> redTerms(List<GenPolynomial<C>> groebnerBasis) {
        int i;
        if (groebnerBasis == null || groebnerBasis.size() == 0) {
            throw new IllegalArgumentException("groebnerBasis may not be null or empty");
        }
        GenPolynomialRing ring = groebnerBasis.get((int)0).ring;
        int numberOfVariables = ring.nvar;
        long[] degrees = new long[numberOfVariables];
        ArrayList<GenPolynomial<C>> terms = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> g : groebnerBasis) {
            if (g.isONE()) {
                terms.clear();
                return terms;
            }
            ExpVector e = g.leadingExpVector();
            if (e.totalDeg() != e.maxDeg()) continue;
            for (i = 0; i < numberOfVariables; ++i) {
                long exp = e.getVal(i);
                if (exp <= 0L) continue;
                degrees[i] = exp;
            }
        }
        long max = this.maxArray(degrees);
        for (int i2 = 0; i2 < degrees.length; ++i2) {
            if (degrees[i2] != 0L) continue;
            logger.info((Object)("dimension not zero, setting degree to " + max));
            degrees[i2] = max;
        }
        terms.add(ring.ONE);
        ReductionSeq s = new ReductionSeq();
        for (i = 0; i < numberOfVariables; ++i) {
            GenPolynomial x = ring.univariate(i);
            ArrayList<GenPolynomial<C>> S = new ArrayList<GenPolynomial<C>>(terms);
            for (GenPolynomial genPolynomial : S) {
                int l = 1;
                while ((long)l <= degrees[i]) {
                    void var13_17;
                    GenPolynomial genPolynomial2 = var13_17.multiply(x);
                    if (!s.isReducible(groebnerBasis, genPolynomial2)) {
                        terms.add(genPolynomial2);
                    }
                    ++l;
                }
            }
        }
        return terms;
    }

    GenPolynomialRing<C> createRingOfIndeterminates(GenPolynomialRing<C> ring, int i) {
        RingFactory cfac = ring.coFac;
        int indeterminates = i;
        String[] stringIndeterminates = new String[indeterminates];
        for (int j = 1; j <= indeterminates; ++j) {
            stringIndeterminates[j - 1] = "Y" + j;
        }
        TermOrder invlex = new TermOrder(2);
        GenPolynomialRing cpfac = new GenPolynomialRing(cfac, indeterminates, invlex, stringIndeterminates);
        return cpfac;
    }

    GenPolynomialRing<C> addIndeterminate(GenPolynomialRing<C> ring) {
        String[] stringIndeterminates = new String[1];
        int number = ring.nvar + 1;
        stringIndeterminates[0] = "Y" + number;
        ring = ring.extend(stringIndeterminates);
        return ring;
    }

    long maxArray(long[] t) {
        if (t.length == 0) {
            return 0L;
        }
        long maximum = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (t[i] <= maximum) continue;
            maximum = t[i];
        }
        return maximum;
    }

    @Override
    public void terminate() {
        if (this.sgb == null) {
            return;
        }
        this.sgb.terminate();
    }

    @Override
    public int cancel() {
        if (this.sgb == null) {
            return 0;
        }
        return this.sgb.cancel();
    }
}

