/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.AbstractPair;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderedMinPairlist<C extends RingElem<C>>
extends OrderedPairlist<C> {
    private static final Logger logger = Logger.getLogger(OrderedMinPairlist.class);

    public OrderedMinPairlist() {
    }

    public OrderedMinPairlist(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public OrderedMinPairlist(int m, GenPolynomialRing<C> r) {
        super(m, r);
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> r) {
        return new OrderedMinPairlist<C>(r);
    }

    @Override
    public PairList<C> create(int m, GenPolynomialRing<C> r) {
        return new OrderedMinPairlist<C>(m, r);
    }

    @Override
    public synchronized int put(GenPolynomial<C> p) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        ExpVector e = p.leadingExpVector();
        int l = this.P.size();
        BitSet redi = new BitSet();
        redi.set(0, l);
        this.red.add(redi);
        this.P.add(p);
        for (int j = 0; j < l; ++j) {
            GenPolynomial pj = (GenPolynomial)this.P.get(j);
            ExpVector f = pj.leadingExpVector();
            if (this.moduleVars > 0 && !this.reduction.moduleCriterion(this.moduleVars, e, f)) {
                ((BitSet)this.red.get(j)).clear(l);
                continue;
            }
            ExpVector g = e.lcm(f);
            Pair<C> pair = new Pair<C>(pj, p, j, l);
            boolean c = true;
            if (this.useCriterion4) {
                c = this.reduction.criterion4(pair.pi, pair.pj, g);
            }
            if (c) {
                c = this.criterion3(j, l, g);
            }
            if (!c) {
                ((BitSet)this.red.get(j)).clear(l);
                continue;
            }
            LinkedList<Pair<C>> xl = (LinkedList<Pair<C>>)this.pairlist.get(g);
            if (xl == null) {
                xl = new LinkedList<Pair<C>>();
            }
            xl.addFirst(pair);
            this.pairlist.put(g, xl);
        }
        return this.P.size() - 1;
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator ip = this.pairlist.entrySet().iterator();
        AbstractPair pair = null;
        boolean c = false;
        while (!c && ip.hasNext()) {
            Map.Entry me = ip.next();
            ExpVector g = (ExpVector)me.getKey();
            LinkedList xl = (LinkedList)me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            while (!c && xl.size() > 0) {
                pair = (Pair)xl.removeFirst();
                int i = ((Pair)pair).i;
                int j = ((Pair)pair).j;
                if (!((BitSet)this.red.get(j)).get(i)) {
                    System.out.println("c_y = " + g);
                    continue;
                }
                c = true;
                if (this.useCriterion4) {
                    c = this.reduction.criterion4(((Pair)pair).pi, ((Pair)pair).pj, g);
                }
                if (c) {
                    c = this.criterion3(i, j, g);
                }
                if (!c) {
                    // empty if block
                }
                ((BitSet)this.red.get(j)).clear(i);
            }
            if (xl.size() != 0) continue;
            ip.remove();
        }
        if (!c) {
            pair = null;
        } else {
            pair.maxIndex(this.P.size() - 1);
            ++this.remCount;
            if (logger.isDebugEnabled()) {
                logger.info((Object)("pair(" + ((Pair)pair).j + "," + ((Pair)pair).i + ")"));
            }
        }
        return pair;
    }

    @Override
    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = ((BitSet)this.red.get(j)).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        s = true;
        for (int k = 0; k < this.P.size(); ++k) {
            boolean m;
            GenPolynomial A = (GenPolynomial)this.P.get(k);
            ExpVector ek = A.leadingExpVector();
            boolean bl = m = eij.multipleOf(ek) && eij.compareTo(ek) != 0;
            if (!m) continue;
            if (k < i) {
                boolean bl2 = s = ((BitSet)this.red.get(i)).get(k) || ((BitSet)this.red.get(j)).get(k);
            }
            if (i < k && k < j) {
                boolean bl3 = s = ((BitSet)this.red.get(k)).get(i) || ((BitSet)this.red.get(j)).get(k);
            }
            if (j < k) {
                boolean bl4 = s = ((BitSet)this.red.get(k)).get(i) || ((BitSet)this.red.get(k)).get(j);
            }
            if (s) continue;
            return s;
        }
        return true;
    }
}

