/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBHybridExerClient;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.HybridReducerClientEC;
import edu.jas.gb.HybridReducerServerEC;
import edu.jas.gb.MiReducerServer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.DistThreadPool;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseDistributedHybridEC<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    public static final Logger logger = Logger.getLogger(GroebnerBaseDistributedHybridEC.class);
    public final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final int threadsPerNode;
    protected static final int DEFAULT_THREADS_PER_NODE = 1;
    protected final transient ThreadPool pool;
    protected static final int DEFAULT_PORT = 55711;
    protected final int DHT_PORT;
    protected final String mfile;
    protected final int port;
    private final transient DistThreadPool dtp;
    private final transient DistHashTableServer<Integer> dhts;
    public static final Integer pairTag = 1;
    public static final Integer resultTag = 2;
    public static final Integer ackTag = 3;

    public GroebnerBaseDistributedHybridEC(String mfile) {
        this(mfile, 2, 55711);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads) {
        this(mfile, threads, new ThreadPool(threads), 55711);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads, int port) {
        this(mfile, threads, new ThreadPool(threads), port);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads, int threadsPerNode, int port) {
        this(mfile, threads, threadsPerNode, new ThreadPool(threads), port);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads, ThreadPool pool, int port) {
        this(mfile, threads, 1, pool, port);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads, int threadsPerNode, PairList<C> pl, int port) {
        this(mfile, threads, threadsPerNode, new ThreadPool(threads), pl, port);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads, int threadsPerNode, ThreadPool pool, int port) {
        this(mfile, threads, threadsPerNode, pool, new OrderedPairlist(), port);
    }

    public GroebnerBaseDistributedHybridEC(String mfile, int threads, int threadsPerNode, ThreadPool pool, PairList<C> pl, int port) {
        super(new ReductionPar(), pl);
        this.threads = threads;
        this.mfile = mfile == null || mfile.length() == 0 ? "../util/machines" : mfile;
        if (threads < 1) {
            threads = 1;
        }
        this.threadsPerNode = threadsPerNode;
        if (pool == null) {
            pool = new ThreadPool(threads);
        }
        this.pool = pool;
        this.port = port;
        logger.info((Object)("machine file " + mfile + ", port = " + port));
        this.dtp = new DistThreadPool(this.threads, this.mfile);
        logger.info((Object)("running " + this.dtp));
        this.DHT_PORT = this.dtp.getEC().getMasterPort() + 100;
        this.dhts = new DistHashTableServer(this.DHT_PORT);
        this.dhts.init();
        logger.info((Object)("running " + this.dhts));
    }

    @Override
    public void terminate() {
        this.terminate(true);
    }

    public void terminate(boolean shutDown) {
        this.pool.terminate();
        this.dtp.terminate(shutDown);
        logger.debug((Object)"dhts.terminate()");
        this.dhts.terminate();
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        String master = this.dtp.getEC().getMasterHost();
        GBHybridExerClient gbc = new GBHybridExerClient(master, this.threadsPerNode, this.port, this.DHT_PORT);
        for (int i = 0; i < this.threads; ++i) {
            this.dtp.addJob(gbc);
        }
        List<GenPolynomial<C>> G = this.GBMaster(modv, F);
        return G;
    }

    public List<GenPolynomial<C>> GBMaster(int modv, List<GenPolynomial<C>> F) {
        long t = System.currentTimeMillis();
        ChannelFactory cf = new ChannelFactory(this.port);
        cf.init();
        List<Object> G = new ArrayList<GenPolynomial<C>>();
        PairList<C> pairlist = null;
        boolean oneInGB = false;
        int l = F.size();
        ListIterator<GenPolynomial<C>> it = F.listIterator();
        while (it.hasNext()) {
            GenPolynomial<C> p = it.next();
            if (p.length() > 0) {
                int unused;
                if ((p = p.monic()).isONE()) {
                    oneInGB = true;
                    G.clear();
                    G.add(p);
                }
                if (!oneInGB) {
                    G.add(p);
                }
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                if (p.isONE()) {
                    unused = pairlist.putOne();
                    continue;
                }
                unused = pairlist.put(p);
                continue;
            }
            --l;
        }
        logger.info((Object)("start " + pairlist));
        DistHashTable theList = new DistHashTable("localhost", this.DHT_PORT);
        theList.init();
        List al = pairlist.getList();
        for (int i = 0; i < al.size(); ++i) {
            GenPolynomial nn = theList.put(i, al.get(i));
            if (nn == null) continue;
            logger.info((Object)("double polynomials " + i + ", nn = " + nn + ", al(i) = " + al.get(i)));
        }
        Terminator finner = new Terminator(this.threads * this.threadsPerNode);
        logger.info((Object)("using pool = " + this.pool));
        for (int i = 0; i < this.threads; ++i) {
            HybridReducerServerEC R = new HybridReducerServerEC(this.threadsPerNode, finner, cf, theList, pairlist);
            this.pool.addJob(R);
        }
        logger.info((Object)("main loop waiting " + finner));
        finner.waitDone();
        int ps = theList.size();
        logger.info((Object)("#distributed list = " + ps));
        G = pairlist.getList();
        if (ps != G.size()) {
            logger.info((Object)("#distributed list = " + theList.size() + " #pairlist list = " + G.size()));
        }
        for (GenPolynomial q : theList.getValueList()) {
            if (q == null || q.isZERO()) continue;
            logger.debug((Object)("final q = " + q.leadingExpVector()));
        }
        logger.debug((Object)"distributed list end");
        long time = System.currentTimeMillis();
        List<GenPolynomial<C>> Gp = this.minimalGB(G);
        time = System.currentTimeMillis() - time;
        logger.debug((Object)("parallel gbmi time = " + time));
        G = Gp;
        logger.debug((Object)"server cf.terminate()");
        cf.terminate();
        logger.debug((Object)("server theList.terminate() " + theList.size()));
        theList.clear();
        theList.terminate();
        t = System.currentTimeMillis() - t;
        logger.info((Object)("server GB end, time = " + t + ", " + pairlist.toString()));
        return G;
    }

    public static <C extends RingElem<C>> void clientPart(String host, int threadsPerNode, int port, int dhtport) throws IOException {
        ChannelFactory cf = new ChannelFactory(port + 10);
        cf.init();
        logger.info((Object)("clientPart connecting to " + host + ", port = " + port + ", dhtport = " + dhtport));
        SocketChannel channel = cf.getChannel(host, port);
        TaggedSocketChannel pairChannel = new TaggedSocketChannel(channel);
        pairChannel.init();
        DistHashTable theList = new DistHashTable(host, dhtport);
        theList.init();
        ThreadPool pool = new ThreadPool(threadsPerNode);
        logger.info((Object)("client using pool = " + pool));
        for (int i = 0; i < threadsPerNode; ++i) {
            HybridReducerClientEC Rr = new HybridReducerClientEC(threadsPerNode, pairChannel, i, theList);
            pool.addJob(Rr);
        }
        logger.debug((Object)"clients submitted");
        pool.terminate();
        logger.debug((Object)"client pool.terminate()");
        pairChannel.close();
        logger.debug((Object)"client pairChannel.close()");
        theList.terminate();
        cf.terminate();
        logger.info((Object)"client cf.terminate()");
        channel.close();
        logger.info((Object)"client channel.close()");
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Fp) {
        GenPolynomial<C> a;
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Fp.size());
        ListIterator<GenPolynomial<Object>> it = Fp.listIterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.length() == 0) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<C>> F = new ArrayList<GenPolynomial<C>>(G.size());
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial<Object> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        MiReducerServer[] mirs = new MiReducerServer[G.size()];
        int i = 0;
        F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            ArrayList R = new ArrayList(G.size() + F.size());
            R.addAll(G);
            R.addAll(F);
            mirs[i] = new MiReducerServer(R, a);
            this.pool.addJob(mirs[i]);
            ++i;
            F.add(a);
        }
        G = F;
        F = new ArrayList(G.size());
        for (i = 0; i < mirs.length; ++i) {
            a = mirs[i].getNF();
            F.add(a);
        }
        return F;
    }
}

