/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableLocalRing;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SolvableLocal<C extends GcdRingElem<C>>
implements GcdRingElem<SolvableLocal<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(SolvableLocal.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableLocalRing<C> ring;
    public final GenSolvablePolynomial<C> num;
    public final GenSolvablePolynomial<C> den;
    protected int isunit = -1;

    public SolvableLocal(SolvableLocalRing<C> r) {
        this(r, (GenSolvablePolynomial<C>)r.ring.getZERO());
    }

    public SolvableLocal(SolvableLocalRing<C> r, GenSolvablePolynomial<C> n) {
        this(r, n, (GenSolvablePolynomial<C>)r.ring.getONE(), true);
    }

    public SolvableLocal(SolvableLocalRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d) {
        this(r, n, d, false);
    }

    protected SolvableLocal(SolvableLocalRing<C> r, GenSolvablePolynomial<C> n, GenSolvablePolynomial<C> d, boolean isred) {
        GenSolvablePolynomial p;
        if (d == null || ((GenPolynomial)d).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = r;
        if (((GenPolynomial)d).signum() < 0) {
            n = (GenSolvablePolynomial<GcdRingElem>)((GenPolynomial)n).negate();
            d = (GenSolvablePolynomial<GcdRingElem>)((GenPolynomial)d).negate();
        }
        if (isred) {
            this.num = n;
            this.den = d;
            return;
        }
        if (this.debug) {
            System.out.println("n = " + n + ", d = " + d);
        }
        if ((p = this.ring.ideal.normalform((GenSolvablePolynomial<GcdRingElem>)d)) == null || p.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal, d = " + d);
        }
        GcdRingElem lc = (GcdRingElem)((GenPolynomial)d).leadingBaseCoefficient();
        if (!lc.isONE() && lc.isUnit()) {
            lc = (GcdRingElem)lc.inverse();
            n = ((GenSolvablePolynomial)n).multiplyLeft(lc);
            d = ((GenSolvablePolynomial)d).multiplyLeft(lc);
        }
        if (((GenPolynomial)n).compareTo(d) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)n).negate()).compareTo(d) == 0) {
            this.num = (GenSolvablePolynomial)this.ring.ring.getONE().negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isZERO()) {
            this.num = n;
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)n).isONE()) {
            this.num = n;
            this.den = d;
            return;
        }
        Object[] gcd = PolyGBUtil.syzGcdCofactors(r.ring, n, d);
        if (!gcd[0].isONE()) {
            logger.info((Object)("constructor: gcd = " + Arrays.toString(gcd)));
            n = gcd[1];
            d = gcd[2];
        }
        Object[] simp = this.ring.engine.leftSimplifier((GenSolvablePolynomial<GcdRingElem>)n, (GenSolvablePolynomial<GcdRingElem>)d);
        logger.info((Object)("simp: " + Arrays.toString(simp) + ", " + n + ", " + d));
        this.num = simp[0];
        this.den = simp[1];
    }

    @Override
    public SolvableLocalRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenSolvablePolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public SolvableLocal<C> copy() {
        return new SolvableLocal<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.compareTo(this.den) == 0;
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        GenSolvablePolynomial p = this.ring.ideal.normalform(this.num);
        boolean u = p != null && !p.isZERO();
        this.isunit = u ? 1 : 0;
        return u;
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String s = "{ " + this.num.toString(this.ring.ring.getVars());
            if (this.den.isONE()) {
                return s + " }";
            }
            return s + "| " + this.den.toString(this.ring.ring.getVars()) + " }";
        }
        return "SolvableLocal[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((SolvableLocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(SolvableLocal<C> b) {
        int s2;
        if (b == null || b.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -b.signum();
        }
        int s1 = this.num.signum();
        int t = (s1 - (s2 = b.num.signum())) / 2;
        if (t != 0) {
            System.out.println("compareTo: t = " + t);
            return t;
        }
        if (this.den.compareTo(b.den) == 0) {
            return this.num.compareTo(b.num);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.den, b.den);
        if (this.debug) {
            System.out.println("oc[0] den =<>= oc[1] b.den: (" + oc[0] + ") (" + this.den + ") = (" + oc[1] + ") (" + b.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>> r = oc[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> s = oc[1].multiply(b.num);
        return r.compareTo((GenPolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)s);
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof SolvableLocal)) {
            return false;
        }
        SolvableLocal a = null;
        try {
            a = (SolvableLocal)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.compareTo(a) == 0;
    }

    @Override
    public int hashCode() {
        int h = this.ring.hashCode();
        h = 37 * h + this.num.hashCode();
        h = 37 * h + this.den.hashCode();
        return h;
    }

    @Override
    public SolvableLocal<C> abs() {
        return new SolvableLocal<C>(this.ring, (GenSolvablePolynomial)this.num.abs(), this.den, true);
    }

    @Override
    public SolvableLocal<C> sum(SolvableLocal<C> S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenSolvablePolynomial n = (GenSolvablePolynomial)this.num.sum(S.num);
            return new SolvableLocal<C>(this.ring, n, this.den, true);
        }
        if (this.den.compareTo(S.den) == 0) {
            GenSolvablePolynomial n = (GenSolvablePolynomial)this.num.sum(S.num);
            return new SolvableLocal<C>(this.ring, n, this.den, false);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.den, S.den);
        if (this.debug) {
            System.out.println("oc[0] den =sum= oc[1] S.den: (" + oc[0] + ") (" + this.den + ") = (" + oc[1] + ") (" + S.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[0].multiply(this.den);
        GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<GenSolvablePolynomial<C>>>> n1 = oc[0].multiply(this.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n2 = oc[1].multiply(S.num);
        GenSolvablePolynomial n = (GenSolvablePolynomial)n1.sum(n2);
        return new SolvableLocal<GenSolvablePolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public SolvableLocal<C> negate() {
        return new SolvableLocal<C>(this.ring, (GenSolvablePolynomial)this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public SolvableLocal<C> subtract(SolvableLocal<C> S) {
        return this.sum((SolvableLocal<C>)S.negate());
    }

    @Override
    public SolvableLocal<C> divide(SolvableLocal<C> S) {
        return this.multiply((C)S.inverse());
    }

    @Override
    public SolvableLocal<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new SolvableLocal<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public SolvableLocal<C> remainder(SolvableLocal<C> S) {
        if (S.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + S);
    }

    @Override
    public SolvableLocal<C> multiply(SolvableLocal<C> S) {
        if (S == null || S.isZERO()) {
            return S;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (S.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return S;
        }
        if (this.den.isONE() && S.den.isONE()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> n = this.num.multiply(S.num);
            return new SolvableLocal<GenSolvablePolynomial<C>>(this.ring, n, this.den, true);
        }
        GenSolvablePolynomial<C>[] oc = this.ring.engine.leftOreCond(this.num, S.den);
        if (this.debug) {
            System.out.println("oc[0] num =mult= oc[1] S.den: (" + oc[0] + ") (" + this.num + ") = (" + oc[1] + ") (" + S.den + ")");
        }
        GenSolvablePolynomial<GenSolvablePolynomial<C>> n = oc[1].multiply(S.num);
        GenSolvablePolynomial<GenSolvablePolynomial<C>> d = oc[0].multiply(this.den);
        return new SolvableLocal<GenSolvablePolynomial<C>>(this.ring, n, d, false);
    }

    @Override
    public SolvableLocal<C> multiply(GenSolvablePolynomial<C> b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        SolvableLocal<C> B = new SolvableLocal<C>(this.ring, b);
        return this.multiply((C)B);
    }

    @Override
    public SolvableLocal<C> multiply(C b) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (b.isONE()) {
            return this;
        }
        GenPolynomial B = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply((RingElem)b);
        return this.multiply((C)B);
    }

    @Override
    public SolvableLocal<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial B = ((GenSolvablePolynomial)this.ring.ring.getONE()).multiply(e);
        return this.multiply((C)B);
    }

    public SolvableLocal<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        return this;
    }

    @Override
    public SolvableLocal<C> gcd(SolvableLocal<C> b) {
        throw new UnsupportedOperationException("gcd not implemented " + this.getClass().getName());
    }

    public SolvableLocal<C>[] egcd(SolvableLocal<C> b) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

