/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.QLRSolvablePolynomialRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class QLRSolvablePolynomial<C extends GcdRingElem<C> & QuotPair<GenPolynomial<D>>, D extends GcdRingElem<D>>
extends GenSolvablePolynomial<C> {
    private static final Logger logger = Logger.getLogger(QLRSolvablePolynomial.class);
    private final boolean debug = logger.isDebugEnabled();
    public final QLRSolvablePolynomialRing<C, D> ring;

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> r) {
        super(r);
        this.ring = r;
    }

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> r, C c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> r, C c) {
        this(r, c, r.evzero);
    }

    public QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> r, GenSolvablePolynomial<C> S) {
        this(r, S.getMap());
    }

    protected QLRSolvablePolynomial(QLRSolvablePolynomialRing<C, D> r, SortedMap<ExpVector, C> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public QLRSolvablePolynomialRing<C, D> factory() {
        return this.ring;
    }

    @Override
    public QLRSolvablePolynomial<C, D> copy() {
        return new QLRSolvablePolynomial<C, D>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof QLRSolvablePolynomial)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(QLRSolvablePolynomial<C, D> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        if (Bp.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return Bp;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        if (this.debug) {
            logger.debug((Object)("ring = " + this.ring));
        }
        ExpVector Z = this.ring.evzero;
        GenSolvablePolynomial Dp = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial zero = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        GcdRingElem one = (GcdRingElem)this.ring.getONECoefficient();
        Object C1 = null;
        Object C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        for (Map.Entry y : A.entrySet()) {
            GcdRingElem a = (GcdRingElem)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            if (this.debug) {
                logger.info((Object)("e = " + e + ", a = " + a));
            }
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            for (Map.Entry x : Bk) {
                GcdRingElem b = (GcdRingElem)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                if (this.debug) {
                    logger.info((Object)("f = " + f + ", b = " + b));
                }
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                QLRSolvablePolynomial<GcdRingElem<GcdRingElem>, D> Cps = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.isCommutative() || ((QuotPair)((Object)b)).isConstant() || e.isZERO()) {
                    Cps = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, b, e);
                    if (this.debug) {
                        logger.info((Object)("symmetric coeff: b = " + b + ", e = " + e));
                    }
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric coeff: b = " + b + ", e = " + e));
                    }
                    if (((GenPolynomial)((QuotPair)((Object)b)).denominator()).isONE()) {
                        RecSolvablePolynomial rsp1 = new RecSolvablePolynomial(this.ring.polCoeff, e);
                        RecSolvablePolynomial rsp2 = new RecSolvablePolynomial(this.ring.polCoeff, (GenPolynomial)((QuotPair)((Object)b)).numerator());
                        RecSolvablePolynomial rsp3 = rsp1.multiply(rsp2);
                        QLRSolvablePolynomial<C, D> rsp = this.ring.fromPolyCoefficients(rsp3);
                        Cps = rsp;
                    } else {
                        if (this.debug) {
                            logger.info((Object)("coeff-num: Cps = " + Cps + ", num = " + ((QuotPair)((Object)b)).numerator() + ", den = " + ((QuotPair)((Object)b)).denominator()));
                        }
                        RingFactory bfq = (RingFactory)b.factory();
                        Cps = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, (GcdRingElem)bfq.getONE(), e);
                        QLRSolvablePolynomial<GcdRingElem, D> qv = Cps;
                        GcdRingElem qden = (GcdRingElem)this.ring.qpfac.create(((QuotPair)((Object)b)).denominator());
                        QLRSolvablePolynomial<GcdRingElem, D> v = qv.multiply(qden);
                        QLRSolvablePolynomial<GcdRingElem, D> vl = qv.multiplyLeft(qden);
                        QLRSolvablePolynomial vr = (QLRSolvablePolynomial)v.subtract((GcdRingElem)((Object)vl));
                        GcdRingElem qdeni = (GcdRingElem)this.ring.qpfac.create((RingElem)this.ring.qpfac.pairFactory().getONE(), ((QuotPair)((Object)b)).denominator());
                        QLRSolvablePolynomial<GcdRingElem, D> rq = vr.multiply((C)qdeni);
                        QLRSolvablePolynomial<GcdRingElem, D> qp = (QLRSolvablePolynomial<GcdRingElem, D>)qv.subtract((GcdRingElem)((Object)rq));
                        qp = qp.multiplyLeft(qdeni);
                        Cps = qp;
                        if (!((GenPolynomial)((QuotPair)((Object)b)).numerator()).isONE()) {
                            GcdRingElem qnum = (GcdRingElem)this.ring.qpfac.create(((QuotPair)((Object)b)).numerator());
                            Cps = Cps.multiply(qnum);
                        }
                    }
                }
                if (this.debug) {
                    logger.info((Object)("coeff-den: Cps = " + Cps));
                }
                GenSolvablePolynomial Dps = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
                QLRSolvablePolynomial Ds = null;
                if (this.ring.isCommutative() || Cps.isConstant() || f.isZERO()) {
                    if (this.debug) {
                        logger.info((Object)("symmetric poly: b = " + b + ", e = " + e));
                    }
                    if (Cps.isConstant()) {
                        ExpVector g = e.sum(f);
                        Ds = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, (GcdRingElem)Cps.leadingBaseCoefficient(), g);
                    } else {
                        Ds = this.shift(Cps, f);
                    }
                } else {
                    if (this.debug) {
                        logger.info((Object)("unsymmetric poly: Cps = " + Cps + ", f = " + f));
                    }
                    for (Map.Entry z : Cps.val.entrySet()) {
                        int gl1s;
                        GcdRingElem c = (GcdRingElem)z.getValue();
                        ExpVector g = (ExpVector)z.getKey();
                        if (this.debug) {
                            logger.info((Object)("g = " + g + ", c = " + c));
                        }
                        int[] gp = g.dependencyOnVariables();
                        int gl1 = this.ring.nvar + 1;
                        if (gp.length > 0) {
                            gl1 = gp[0];
                        }
                        if ((gl1s = this.ring.nvar + 1 - gl1) <= fl1s) {
                            ExpVector h = g.sum(f);
                            if (this.debug) {
                                logger.info((Object)("disjoint poly: g = " + g + ", f = " + f + ", h = " + h));
                            }
                            Ds = (QLRSolvablePolynomial<GcdRingElem, D>)zero.sum(one, h);
                        } else {
                            QLRSolvablePolynomial<GcdRingElem, D> D1;
                            QLRSolvablePolynomial<GcdRingElem, D> D2;
                            ExpVector g1 = g.subst(gl1, 0L);
                            ExpVector g2 = Z.subst(gl1, g.getVal(gl1));
                            ExpVector f1 = f.subst(fl1, 0L);
                            ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                            if (this.debug) {
                                logger.info((Object)("poly, g1 = " + g1 + ", f1 = " + f1 + ", Dps = " + Dps));
                                logger.info((Object)("poly, g2 = " + g2 + ", f2 = " + f2));
                            }
                            TableRelation rel = this.ring.table.lookup(g2, f2);
                            if (this.debug) {
                                logger.info((Object)("poly, g  = " + g + ", f  = " + f + ", rel = " + rel));
                            }
                            Ds = new QLRSolvablePolynomial<C, D>(this.ring, rel.p);
                            if (rel.f != null) {
                                D2 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, one, rel.f);
                                Ds = Ds.multiply((C)((GcdRingElem)((Object)D2)));
                                ExpVector g4 = rel.e == null ? g2 : g2.subtract(rel.e);
                                this.ring.table.update(g4, f2, Ds);
                            }
                            if (rel.e != null) {
                                D1 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, one, rel.e);
                                Ds = D1.multiply((GcdRingElem)((Object)Ds));
                                this.ring.table.update(g2, f2, Ds);
                            }
                            if (!f1.isZERO()) {
                                D2 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, one, f1);
                                Ds = Ds.multiply((C)((GcdRingElem)((Object)D2)));
                            }
                            if (!g1.isZERO()) {
                                D1 = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, one, g1);
                                Ds = D1.multiply((GcdRingElem)((Object)Ds));
                            }
                        }
                        Ds = Ds.multiplyLeft((C)c);
                        Dps = (QLRSolvablePolynomial)Dps.sum(Ds);
                    }
                    Ds = Dps;
                }
                Ds = Ds.multiplyLeft((C)a);
                if (this.debug) {
                    logger.debug((Object)("Ds = " + Ds));
                }
                Dp = (QLRSolvablePolynomial)Dp.sum(Ds);
            }
        }
        return Dp;
    }

    public QLRSolvablePolynomial<C, D> multiply(QLRSolvablePolynomial<C, D> S, QLRSolvablePolynomial<C, D> T) {
        if (S.isZERO() || T.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply((C)T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(C b) {
        QLRSolvablePolynomial<C, D> Cp = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (b.isONE()) {
            return this;
        }
        Cp = new QLRSolvablePolynomial<C, D>(this.ring, b, this.ring.evzero);
        return this.multiply((C)Cp);
    }

    public QLRSolvablePolynomial<C, D> multiply(C b, C c) {
        QLRSolvablePolynomial<C, D> Cp = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (c == null || c.isZERO()) {
            return Cp;
        }
        if (b.isONE() && c.isONE()) {
            return this;
        }
        Cp = new QLRSolvablePolynomial<C, D>(this.ring, b, this.ring.evzero);
        QLRSolvablePolynomial<C, D> Dp = new QLRSolvablePolynomial<C, D>(this.ring, c, this.ring.evzero);
        return this.multiply((C)Cp, (C)Dp);
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        GcdRingElem b = (GcdRingElem)this.ring.getONECoefficient();
        return this.multiply((C)b, e);
    }

    public QLRSolvablePolynomial<C, D> multiply(ExpVector e, ExpVector f) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (f == null || f.isZERO()) {
            return this;
        }
        GcdRingElem b = (GcdRingElem)this.ring.getONECoefficient();
        return this.multiply((C)b, e, (C)b, f);
    }

    public QLRSolvablePolynomial<C, D> multiply(C b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (b.isONE() && e.isZERO()) {
            return this;
        }
        QLRSolvablePolynomial<C, D> Cp = new QLRSolvablePolynomial<C, D>(this.ring, b, e);
        return this.multiply((C)Cp);
    }

    public QLRSolvablePolynomial<C, D> multiply(C b, ExpVector e, C c, ExpVector f) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (b.isONE() && e.isZERO() && c.isONE() && f.isZERO()) {
            return this;
        }
        QLRSolvablePolynomial<C, D> Cp = new QLRSolvablePolynomial<C, D>(this.ring, b, e);
        QLRSolvablePolynomial<C, D> Dp = new QLRSolvablePolynomial<C, D>(this.ring, c, f);
        return this.multiply((C)Cp, (C)Dp);
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(C b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        QLRSolvablePolynomial<QLRSolvablePolynomial, D> Cp = new QLRSolvablePolynomial<QLRSolvablePolynomial, D>(this.ring, (QLRSolvablePolynomial)b, e);
        return Cp.multiply(this);
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        GcdRingElem b = (GcdRingElem)this.ring.getONECoefficient();
        QLRSolvablePolynomial<GcdRingElem, D> Cp = new QLRSolvablePolynomial<GcdRingElem, D>(this.ring, b, e);
        return Cp.multiply((GcdRingElem)((Object)this));
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(C b) {
        GenSolvablePolynomial Cp = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((QLRSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            GcdRingElem c = b.multiply((GcdRingElem)a);
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    public QLRSolvablePolynomial<C, D> multiplyLeft(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft((C)((GcdRingElem)m.getValue()), m.getKey());
    }

    @Override
    public QLRSolvablePolynomial<C, D> multiply(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply((C)((GcdRingElem)m.getValue()), m.getKey());
    }

    protected QLRSolvablePolynomial<C, D> shift(QLRSolvablePolynomial<C, D> B, ExpVector f) {
        GenSolvablePolynomial C = ((QLRSolvablePolynomial)this.ring.getZERO()).copy();
        if (B == null || B.isZERO()) {
            return C;
        }
        if (f == null || f.isZERO()) {
            return B;
        }
        SortedMap Cm = ((QLRSolvablePolynomial)C).val;
        SortedMap Bm = B.val;
        for (Map.Entry y : Bm.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            ExpVector d = e.sum(f);
            if (a.isZERO()) continue;
            Cm.put(d, a);
        }
        return C;
    }
}

